/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.Objects;
import java.util.Optional;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.util.ValidateUtils;

public abstract class Property$BaseProperty
implements Property {
    private final String name;
    private final Class type;
    private final Optional defaultValue;

    protected Property$BaseProperty(String string, Class clazz) {
        this(string, clazz, null);
    }

    protected Property$BaseProperty(String string, Class clazz, Object object) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(string, "No name provided");
        this.type = Objects.requireNonNull(clazz, "Type must be provided");
        this.defaultValue = Optional.ofNullable(object);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public Optional getDefault() {
        return this.defaultValue;
    }

    @Override
    public Optional get(PropertyResolver propertyResolver) {
        Object object = PropertyResolverUtils.resolvePropertyValue(propertyResolver, this.getName());
        return object != null ? Optional.of(this.fromStorage(object)) : this.getDefault();
    }

    @Override
    public Object getOrCustomDefault(PropertyResolver propertyResolver, Object object) {
        Object object2 = PropertyResolverUtils.resolvePropertyValue(propertyResolver, this.getName());
        return object2 != null ? this.fromStorage(object2) : object;
    }

    @Override
    public void set(PropertyResolver propertyResolver, Object object) {
        PropertyResolverUtils.updateProperty(propertyResolver, this.getName(), this.toStorage(object));
    }

    protected Object toStorage(Object object) {
        return object;
    }

    protected abstract Object fromStorage(Object var1);

    public String toString() {
        return "Property[" + this.getName() + "](" + this.getType().getSimpleName() + "]";
    }
}

