/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.apache.sshd.common.NamedResource$1;
import org.apache.sshd.common.util.GenericUtils;

@FunctionalInterface
public interface NamedResource {
    public static final Function NAME_EXTRACTOR = namedResource -> namedResource == null ? null : namedResource.getName();
    public static final Comparator BY_NAME_COMPARATOR = Comparator.comparing(NAME_EXTRACTOR, String.CASE_INSENSITIVE_ORDER);

    public String getName();

    public static List getNameList(Collection collection) {
        return GenericUtils.map(collection, NamedResource::getName);
    }

    public static String getNames(Collection collection) {
        List list = NamedResource.getNameList(collection);
        return GenericUtils.join((Iterable)list, ',');
    }

    public static NamedResource removeByName(String string, Comparator comparator, Collection collection) {
        NamedResource namedResource = NamedResource.findByName(string, comparator, collection);
        if (namedResource != null) {
            collection.remove(namedResource);
        }
        return namedResource;
    }

    public static NamedResource findByName(String string, Comparator comparator, Collection collection) {
        return GenericUtils.isEmpty(string) || GenericUtils.isEmpty(collection) ? null : (NamedResource)GenericUtils.stream(collection).filter(namedResource -> comparator.compare(string, namedResource.getName()) == 0).findFirst().orElse(null);
    }

    public static NamedResource findFirstMatchByName(Collection collection, Comparator comparator, Collection collection2) {
        return GenericUtils.isEmpty(collection) || GenericUtils.isEmpty(collection2) ? null : (NamedResource)GenericUtils.stream(collection2).filter(namedResource -> GenericUtils.findFirstMatchingMember(string -> comparator.compare(string, namedResource.getName()) == 0, collection) != null).findFirst().orElse(null);
    }

    public static NamedResource ofName(String string) {
        return new NamedResource$1(string);
    }

    public static int safeCompareByName(NamedResource namedResource, NamedResource namedResource2, boolean bl2) {
        String string = namedResource == null ? null : namedResource.getName();
        String string2 = namedResource2 == null ? null : namedResource2.getName();
        return GenericUtils.safeCompare(string, string2, bl2);
    }
}

