/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.net.SocketTimeoutException;
import java.nio.channels.Channel;
import java.time.Duration;
import org.apache.sshd.common.CommonModuleProperties;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;

public interface Closeable
extends Channel {
    public CloseFuture close(boolean var1);

    public void addCloseFutureListener(SshFutureListener var1);

    public void removeCloseFutureListener(SshFutureListener var1);

    public boolean isClosed();

    public boolean isClosing();

    @Override
    default public boolean isOpen() {
        return !this.isClosed() && !this.isClosing();
    }

    @Override
    default public void close() {
        Closeable.close(this);
    }

    public static Duration getMaxCloseWaitTime(PropertyResolver propertyResolver) {
        return (Duration)CommonModuleProperties.CLOSE_WAIT_TIMEOUT.getRequired(propertyResolver);
    }

    public static void close(Closeable closeable) {
        Duration duration;
        CloseFuture closeFuture;
        boolean bl2;
        if (closeable == null) {
            return;
        }
        if (!(closeable.isClosed() || closeable.isClosing() || (bl2 = (closeFuture = closeable.close(true)).await(duration = closeable instanceof PropertyResolver ? Closeable.getMaxCloseWaitTime((PropertyResolver)((Object)closeable)) : (Duration)CommonModuleProperties.CLOSE_WAIT_TIMEOUT.getRequiredDefault())))) {
            throw new SocketTimeoutException("Failed to receive closure confirmation within " + duration + " millis");
        }
    }
}

