/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriterResolver;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.nativefs.NativeFileSystemFactory;
import org.apache.sshd.common.forward.DefaultForwarderFactory;
import org.apache.sshd.common.forward.ForwarderFactory;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.random.SingletonRandomFactory;
import org.apache.sshd.common.session.UnknownChannelReferenceHandler;
import org.apache.sshd.common.session.helpers.DefaultUnknownChannelReferenceHandler;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.util.ObjectBuilder;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.forward.RejectAllForwardingFilter;

public class BaseBuilder
implements ObjectBuilder {
    public static final FileSystemFactory DEFAULT_FILE_SYSTEM_FACTORY = NativeFileSystemFactory.INSTANCE;
    public static final ForwardingFilter DEFAULT_FORWARDING_FILTER = RejectAllForwardingFilter.INSTANCE;
    public static final ForwarderFactory DEFAULT_FORWARDER_FACTORY = DefaultForwarderFactory.INSTANCE;
    public static final List DEFAULT_CIPHERS_PREFERENCE = Collections.unmodifiableList(Arrays.asList(BuiltinCiphers.cc20p1305_openssh, BuiltinCiphers.aes128ctr, BuiltinCiphers.aes192ctr, BuiltinCiphers.aes256ctr, BuiltinCiphers.aes128gcm, BuiltinCiphers.aes256gcm, BuiltinCiphers.aes128cbc, BuiltinCiphers.aes192cbc, BuiltinCiphers.aes256cbc));
    public static final List DEFAULT_KEX_PREFERENCE = Collections.unmodifiableList(Arrays.asList(BuiltinDHFactories.curve25519, BuiltinDHFactories.curve25519_libssh, BuiltinDHFactories.curve448, BuiltinDHFactories.ecdhp521, BuiltinDHFactories.ecdhp384, BuiltinDHFactories.ecdhp256, BuiltinDHFactories.dhgex256, BuiltinDHFactories.dhg18_512, BuiltinDHFactories.dhg17_512, BuiltinDHFactories.dhg16_512, BuiltinDHFactories.dhg15_512, BuiltinDHFactories.dhg14_256));
    public static final List DEFAULT_MAC_PREFERENCE = Collections.unmodifiableList(Arrays.asList(BuiltinMacs.hmacsha256etm, BuiltinMacs.hmacsha512etm, BuiltinMacs.hmacsha1etm, BuiltinMacs.hmacsha256, BuiltinMacs.hmacsha512, BuiltinMacs.hmacsha1));
    public static final List DEFAULT_SIGNATURE_PREFERENCE = Collections.unmodifiableList(Arrays.asList(BuiltinSignatures.nistp256_cert, BuiltinSignatures.nistp384_cert, BuiltinSignatures.nistp521_cert, BuiltinSignatures.ed25519_cert, BuiltinSignatures.rsaSHA512_cert, BuiltinSignatures.rsaSHA256_cert, BuiltinSignatures.nistp256, BuiltinSignatures.nistp384, BuiltinSignatures.nistp521, BuiltinSignatures.ed25519, BuiltinSignatures.sk_ecdsa_sha2_nistp256, BuiltinSignatures.sk_ssh_ed25519, BuiltinSignatures.rsaSHA512, BuiltinSignatures.rsaSHA256, BuiltinSignatures.rsa));
    public static final UnknownChannelReferenceHandler DEFAULT_UNKNOWN_CHANNEL_REFERENCE_HANDLER = DefaultUnknownChannelReferenceHandler.INSTANCE;
    protected Factory factory;
    protected List keyExchangeFactories;
    protected List cipherFactories;
    protected List compressionFactories;
    protected List macFactories;
    protected List signatureFactories;
    protected Factory randomFactory;
    protected List channelFactories;
    protected FileSystemFactory fileSystemFactory;
    protected ForwarderFactory forwarderFactory;
    protected List globalRequestHandlers;
    protected ForwardingFilter forwardingFilter;
    protected ChannelStreamWriterResolver channelStreamPacketWriterResolver;
    protected UnknownChannelReferenceHandler unknownChannelReferenceHandler;
    protected KexExtensionHandler kexExtensionHandler;

    protected BaseBuilder fillWithDefaultValues() {
        if (this.randomFactory == null) {
            this.randomFactory = new SingletonRandomFactory(SecurityUtils.getRandomFactory());
        }
        if (this.cipherFactories == null) {
            this.cipherFactories = BaseBuilder.setUpDefaultCiphers(false);
        }
        if (this.macFactories == null) {
            this.macFactories = BaseBuilder.setUpDefaultMacs(false);
        }
        if (this.fileSystemFactory == null) {
            this.fileSystemFactory = DEFAULT_FILE_SYSTEM_FACTORY;
        }
        if (this.forwardingFilter == null) {
            this.forwardingFilter = DEFAULT_FORWARDING_FILTER;
        }
        if (this.forwarderFactory == null) {
            this.forwarderFactory = DEFAULT_FORWARDER_FACTORY;
        }
        if (this.unknownChannelReferenceHandler == null) {
            this.unknownChannelReferenceHandler = DEFAULT_UNKNOWN_CHANNEL_REFERENCE_HANDLER;
        }
        return this.me();
    }

    public BaseBuilder keyExchangeFactories(List list) {
        this.keyExchangeFactories = list;
        return this.me();
    }

    public BaseBuilder kexExtensionHandler(KexExtensionHandler kexExtensionHandler) {
        this.kexExtensionHandler = kexExtensionHandler;
        return this.me();
    }

    public BaseBuilder signatureFactories(List list) {
        this.signatureFactories = list;
        return this.me();
    }

    public BaseBuilder randomFactory(Factory factory) {
        this.randomFactory = factory;
        return this.me();
    }

    public BaseBuilder cipherFactories(List list) {
        this.cipherFactories = list;
        return this.me();
    }

    public BaseBuilder compressionFactories(List list) {
        this.compressionFactories = list;
        return this.me();
    }

    public BaseBuilder macFactories(List list) {
        this.macFactories = list;
        return this.me();
    }

    public BaseBuilder channelFactories(List list) {
        this.channelFactories = list;
        return this.me();
    }

    public BaseBuilder fileSystemFactory(FileSystemFactory fileSystemFactory) {
        this.fileSystemFactory = fileSystemFactory;
        return this.me();
    }

    public BaseBuilder forwardingFilter(ForwardingFilter forwardingFilter) {
        this.forwardingFilter = forwardingFilter;
        return this.me();
    }

    public BaseBuilder forwarderFactory(ForwarderFactory forwarderFactory) {
        this.forwarderFactory = forwarderFactory;
        return this.me();
    }

    public BaseBuilder globalRequestHandlers(List list) {
        this.globalRequestHandlers = list;
        return this.me();
    }

    public BaseBuilder factory(Factory factory) {
        this.factory = factory;
        return this.me();
    }

    public BaseBuilder channelStreamPacketWriterResolver(ChannelStreamWriterResolver channelStreamWriterResolver) {
        this.channelStreamPacketWriterResolver = channelStreamWriterResolver;
        return this.me();
    }

    public BaseBuilder unknownChannelReferenceHandler(UnknownChannelReferenceHandler unknownChannelReferenceHandler) {
        this.unknownChannelReferenceHandler = unknownChannelReferenceHandler;
        return this.me();
    }

    public AbstractFactoryManager build(boolean bl2) {
        if (bl2) {
            this.fillWithDefaultValues();
        }
        AbstractFactoryManager abstractFactoryManager = (AbstractFactoryManager)this.factory.create();
        abstractFactoryManager.setKexExtensionHandler(this.kexExtensionHandler);
        abstractFactoryManager.setKeyExchangeFactories(this.keyExchangeFactories);
        abstractFactoryManager.setSignatureFactories(this.signatureFactories);
        abstractFactoryManager.setRandomFactory(this.randomFactory);
        abstractFactoryManager.setCipherFactories(this.cipherFactories);
        abstractFactoryManager.setCompressionFactories(this.compressionFactories);
        abstractFactoryManager.setMacFactories(this.macFactories);
        abstractFactoryManager.setChannelFactories(this.channelFactories);
        abstractFactoryManager.setFileSystemFactory(this.fileSystemFactory);
        abstractFactoryManager.setForwardingFilter(this.forwardingFilter);
        abstractFactoryManager.setForwarderFactory(this.forwarderFactory);
        abstractFactoryManager.setGlobalRequestHandlers(this.globalRequestHandlers);
        abstractFactoryManager.setChannelStreamWriterResolver(this.channelStreamPacketWriterResolver);
        abstractFactoryManager.setUnknownChannelReferenceHandler(this.unknownChannelReferenceHandler);
        return abstractFactoryManager;
    }

    @Override
    public AbstractFactoryManager build() {
        return this.build(true);
    }

    protected BaseBuilder me() {
        return this;
    }

    public static List setUpDefaultCiphers(boolean bl2) {
        return NamedFactory.setUpBuiltinFactories(bl2, DEFAULT_CIPHERS_PREFERENCE);
    }

    public static List setUpDefaultMacs(boolean bl2) {
        return NamedFactory.setUpBuiltinFactories(bl2, DEFAULT_MAC_PREFERENCE);
    }
}

