/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.simple;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.security.KeyPair;
import java.util.Objects;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionCreator;
import org.apache.sshd.client.simple.AbstractSimpleClient;
import org.apache.sshd.client.simple.AbstractSimpleClientSessionCreator$1;
import org.apache.sshd.client.simple.SimpleClient;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.ValidateUtils;

public abstract class AbstractSimpleClientSessionCreator
extends AbstractSimpleClient
implements ClientSessionCreator {
    private long connectTimeout;
    private long authenticateTimeout;

    protected AbstractSimpleClientSessionCreator() {
        this(Long.MAX_VALUE, Long.MAX_VALUE);
    }

    protected AbstractSimpleClientSessionCreator(long l2, long l3) {
        this.setConnectTimeout(l2);
        this.setAuthenticationTimeout(l3);
    }

    @Override
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(long l2) {
        ValidateUtils.checkTrue(l2 > 0L, "Non-positive connect timeout: %d", l2);
        this.connectTimeout = l2;
    }

    @Override
    public long getAuthenticationTimeout() {
        return this.authenticateTimeout;
    }

    @Override
    public void setAuthenticationTimeout(long l2) {
        ValidateUtils.checkTrue(l2 > 0L, "Non-positive authentication timeout: %d", l2);
        this.authenticateTimeout = l2;
    }

    @Override
    public ClientSession sessionLogin(SocketAddress socketAddress, String string, String string2) {
        return this.loginSession(this.connect(string, socketAddress), string2);
    }

    @Override
    public ClientSession sessionLogin(SocketAddress socketAddress, String string, KeyPair keyPair) {
        return this.loginSession(this.connect(string, socketAddress), keyPair);
    }

    @Override
    public ClientSession sessionLogin(String string, String string2) {
        return this.loginSession(this.connect(string), string2);
    }

    @Override
    public ClientSession sessionLogin(String string, KeyPair keyPair) {
        return this.loginSession(this.connect(string), keyPair);
    }

    protected ClientSession loginSession(ConnectFuture connectFuture, String string) {
        return this.authSession((ConnectFuture)connectFuture.verify(this.getConnectTimeout()), string);
    }

    protected ClientSession loginSession(ConnectFuture connectFuture, KeyPair keyPair) {
        return this.authSession((ConnectFuture)connectFuture.verify(this.getConnectTimeout()), keyPair);
    }

    protected ClientSession authSession(ConnectFuture connectFuture, String string) {
        ClientSession clientSession = (ClientSession)connectFuture.getSession();
        clientSession.addPasswordIdentity(string);
        return this.authSession(clientSession);
    }

    protected ClientSession authSession(ConnectFuture connectFuture, KeyPair keyPair) {
        ClientSession clientSession = (ClientSession)connectFuture.getSession();
        clientSession.addPublicKeyIdentity(keyPair);
        return this.authSession(clientSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientSession authSession(ClientSession clientSession) {
        ClientSession clientSession2 = clientSession;
        IOException iOException = null;
        try {
            AuthFuture authFuture = clientSession2.auth();
            authFuture.verify(this.getAuthenticationTimeout());
            clientSession2 = null;
        }
        catch (IOException iOException2) {
            iOException = (IOException)ExceptionUtils.accumulateException(iOException, iOException2);
        }
        finally {
            if (clientSession2 != null) {
                try {
                    clientSession2.close();
                }
                catch (IOException iOException3) {
                    iOException = (IOException)ExceptionUtils.accumulateException(iOException, iOException3);
                }
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        return clientSession;
    }

    public static SimpleClient wrap(ClientSessionCreator clientSessionCreator, Channel channel) {
        Objects.requireNonNull(clientSessionCreator, "No sessions creator");
        Objects.requireNonNull(channel, "No channel");
        return new AbstractSimpleClientSessionCreator$1(clientSessionCreator, channel);
    }
}

