/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session.forward;

import java.util.Objects;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.forward.PortForwardingTracker;
import org.apache.sshd.common.util.net.ConnectionEndpointsIndicator;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class ExplicitPortForwardingTracker
extends PortForwardingTracker
implements ConnectionEndpointsIndicator {
    private final boolean localForwarding;
    private final SshdSocketAddress remoteAddress;

    public ExplicitPortForwardingTracker(ClientSession clientSession, boolean bl2, SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2, SshdSocketAddress sshdSocketAddress3) {
        super(clientSession, sshdSocketAddress, sshdSocketAddress3);
        this.localForwarding = bl2;
        this.remoteAddress = Objects.requireNonNull(sshdSocketAddress2, "No remote address specified");
    }

    public boolean isLocalForwarding() {
        return this.localForwarding;
    }

    @Override
    public SshdSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public void close() {
        if (this.open.getAndSet(false)) {
            ClientSession clientSession = this.getClientSession();
            if (this.isLocalForwarding()) {
                clientSession.stopLocalPortForwarding(this.getBoundAddress());
            } else {
                clientSession.stopRemotePortForwarding(this.getRemoteAddress());
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[localForwarding=" + this.isLocalForwarding() + ", remote=" + this.getRemoteAddress() + "]";
    }
}

