/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.auth.UserAuth;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.client.session.ClientUserAuthService$1;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.auth.UserAuthMethodFactory;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.core.CoreModuleProperties;

public class ClientUserAuthService
extends AbstractCloseable
implements ClientSessionHolder,
Service {
    protected final AtomicReference authFutureHolder = new AtomicReference();
    protected final ClientSessionImpl clientSession;
    protected final List authFactories;
    protected final List clientMethods;
    protected List serverMethods;
    private final Map properties = new ConcurrentHashMap();
    private String service;
    private UserAuth userAuth;
    private int currentMethod;
    private final Object initLock = new Object();
    private boolean started;
    private Runnable initialRequestSender;

    public ClientUserAuthService(Session session) {
        this.clientSession = (ClientSessionImpl)ValidateUtils.checkInstanceOf((Object)session, ClientSessionImpl.class, "Client side service used on server side: %s", (Object)session);
        this.authFactories = (List)ValidateUtils.checkNotNullAndNotEmpty(this.clientSession.getUserAuthFactories(), "No user auth factories for %s", session);
        this.clientMethods = new ArrayList();
        String string = (String)CoreModuleProperties.PREFERRED_AUTHS.getOrNull(session);
        boolean bl2 = this.log.isDebugEnabled();
        if (GenericUtils.isEmpty(string)) {
            for (UserAuthFactory userAuthFactory : this.authFactories) {
                this.clientMethods.add(userAuthFactory.getName());
            }
        } else {
            if (bl2) {
                this.log.debug("ClientUserAuthService({}) use configured preferences: {}", (Object)session, (Object)string);
            }
            for (String string2 : GenericUtils.split(string, ',')) {
                UserAuthFactory userAuthFactory = (UserAuthFactory)NamedResource.findByName(string2, String.CASE_INSENSITIVE_ORDER, this.authFactories);
                if (userAuthFactory != null) {
                    this.clientMethods.add(string2);
                    continue;
                }
                if (!bl2) continue;
                this.log.debug("ClientUserAuthService({}) skip unknown preferred authentication method: {}", (Object)session, (Object)string2);
            }
        }
        if (bl2) {
            this.log.debug("ClientUserAuthService({}) client methods: {}", (Object)session, (Object)this.clientMethods);
        }
        this.clientSession.resetAuthTimeout();
    }

    @Override
    public ClientSession getSession() {
        return this.getClientSession();
    }

    @Override
    public ClientSession getClientSession() {
        return this.clientSession;
    }

    @Override
    public Map getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Runnable runnable;
        Object object = this.initLock;
        synchronized (object) {
            this.started = true;
            runnable = this.initialRequestSender;
            this.initialRequestSender = null;
        }
        if (runnable != null) {
            runnable.run();
        }
    }

    public String getCurrentServiceName() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthFuture auth(String string) {
        this.service = ValidateUtils.checkNotNullAndNotEmpty(string, "No service name");
        ClientSession clientSession = this.getClientSession();
        AuthFuture authFuture = this.updateCurrentAuthFuture(clientSession, string);
        this.serverMethods = null;
        this.currentMethod = 0;
        this.clearUserAuth();
        Runnable runnable = () -> {
            try {
                this.sendInitialAuthRequest(clientSession, string);
            }
            catch (Exception exception) {
                authFuture.setException(exception);
            }
        };
        Object object = this.initLock;
        synchronized (object) {
            if (!this.started) {
                this.initialRequestSender = runnable;
                runnable = null;
            }
        }
        if (runnable != null) {
            runnable.run();
        }
        return authFuture;
    }

    protected AuthFuture updateCurrentAuthFuture(ClientSession clientSession, String string) {
        AuthFuture authFuture = this.createAuthFuture(clientSession, string);
        if (!this.authFutureHolder.compareAndSet(null, authFuture)) {
            throw new SshException("Authentication already ongoing");
        }
        return authFuture;
    }

    protected AuthFuture createAuthFuture(ClientSession clientSession, String string) {
        return new ClientUserAuthService$1(this, string, this.clientSession.getFutureLock());
    }

    protected IoWriteFuture sendInitialAuthRequest(ClientSession clientSession, String string) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("auth({})[{}] send SSH_MSG_USERAUTH_REQUEST for 'none'", (Object)clientSession, (Object)string);
        }
        String string2 = clientSession.getUsername();
        Buffer buffer = clientSession.createBuffer((byte)50, string2.length() + string.length() + 32);
        buffer.putString(string2);
        buffer.putString(string);
        buffer.putString("none");
        return clientSession.writePacket(buffer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(int n2, Buffer buffer) {
        ClientSession clientSession = this.getClientSession();
        AuthFuture authFuture = (AuthFuture)this.authFutureHolder.get();
        boolean bl2 = this.log.isDebugEnabled();
        if (authFuture != null) {
            if (authFuture.isSuccess()) {
                this.log.error("process({}) unexpected authenticated client command: {}", (Object)clientSession, (Object)SshConstants.getCommandMessageName(n2));
                throw new IllegalStateException("UserAuth message delivered to authenticated client");
            }
            if (authFuture.isCanceled()) {
                return;
            }
            if (authFuture.isDone()) {
                if (!bl2) return;
                this.log.debug("process({}) Ignoring random message - cmd={}", (Object)clientSession, (Object)SshConstants.getCommandMessageName(n2));
                return;
            }
        }
        if (n2 == 53) {
            String string = buffer.getString();
            String string2 = buffer.getString();
            if (bl2) {
                this.log.debug("process({}) Welcome banner(lang={}): {}", new Object[]{clientSession, string2, string});
            }
            UserInteraction userInteraction = clientSession.getUserInteraction();
            try {
                if (userInteraction == null || !userInteraction.isInteractionAllowed(clientSession)) return;
                userInteraction.welcome(clientSession, string, string2);
                return;
            }
            catch (Error error) {
                this.warn("process({}) failed ({}) to consult interaction: {}", clientSession, error.getClass().getSimpleName(), error.getMessage(), error);
                RuntimeSshException runtimeSshException = new RuntimeSshException(error);
                if (authFuture == null) throw runtimeSshException;
                authFuture.setException(runtimeSshException);
                throw runtimeSshException;
            }
        } else if (authFuture != null) {
            this.processUserAuth(n2, buffer, authFuture);
            return;
        } else {
            if (!bl2) return;
            this.log.debug("process({}) Ignoring random message - cmd={}", (Object)clientSession, (Object)SshConstants.getCommandMessageName(n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processUserAuth(int n2, Buffer buffer, AuthFuture authFuture) {
        ClientSession clientSession = this.getClientSession();
        if (n2 == 52) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("processUserAuth({}) SSH_MSG_USERAUTH_SUCCESS Succeeded with {}", (Object)clientSession, (Object)(this.userAuth == null ? "<unknown>" : this.userAuth.getName()));
            }
            if (this.userAuth != null) {
                try {
                    this.userAuth.signalAuthMethodSuccess(clientSession, this.service, buffer);
                }
                finally {
                    this.clearUserAuth();
                }
            }
            clientSession.setAuthenticated();
            ((ClientSessionImpl)clientSession).switchToNextService();
            authFuture.setAuthed(true);
            return;
        }
        authFuture.setCancellable(true);
        if (authFuture.isCanceled()) {
            authFuture.getCancellation().setCanceled();
            this.clearUserAuth();
            return;
        }
        if (n2 == 51) {
            String string = buffer.getString();
            boolean bl2 = buffer.getBoolean();
            if (this.log.isDebugEnabled()) {
                this.log.debug("processUserAuth({}) Received SSH_MSG_USERAUTH_FAILURE - partial={}, methods={}", new Object[]{clientSession, bl2, string});
            }
            if (bl2 || this.serverMethods == null) {
                this.serverMethods = Arrays.asList(GenericUtils.split(string, ','));
                this.currentMethod = 0;
                if (this.userAuth != null) {
                    try {
                        this.userAuth.signalAuthMethodFailure(clientSession, this.service, bl2, Collections.unmodifiableList(this.serverMethods), buffer);
                    }
                    finally {
                        this.clearUserAuth();
                    }
                }
            }
            this.tryNext(n2, authFuture);
            return;
        }
        if (this.userAuth == null) {
            throw new IllegalStateException("Received unknown packet: " + SshConstants.getCommandMessageName(n2));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("processUserAuth({}) delegate processing of {} to {}", new Object[]{clientSession, SshConstants.getCommandMessageName(n2), this.userAuth.getName()});
        }
        buffer.rpos(buffer.rpos() - 1);
        if (!this.userAuth.process(buffer)) {
            this.tryNext(n2, authFuture);
        } else {
            authFuture.setCancellable(this.userAuth.isCancellable());
        }
    }

    protected void tryNext(int n2, AuthFuture authFuture) {
        ClientSession clientSession = this.getClientSession();
        boolean bl2 = this.log.isDebugEnabled();
        while (true) {
            if (this.userAuth == null) {
                if (bl2) {
                    this.log.debug("tryNext({}) starting authentication mechanisms: client={}, server={}", new Object[]{clientSession, this.clientMethods, this.serverMethods});
                }
            } else if (!this.userAuth.process(null)) {
                if (bl2) {
                    this.log.debug("tryNext({}) no initial request sent by method={}", (Object)clientSession, (Object)this.userAuth.getName());
                }
                this.clearUserAuth();
                ++this.currentMethod;
            } else {
                if (bl2) {
                    this.log.debug("tryNext({}) successfully processed initial buffer by method={}", (Object)clientSession, (Object)this.userAuth.getName());
                }
                return;
            }
            String string = null;
            while (this.currentMethod < this.clientMethods.size() && !this.serverMethods.contains(string = (String)this.clientMethods.get(this.currentMethod))) {
                ++this.currentMethod;
            }
            if (this.currentMethod >= this.clientMethods.size()) {
                if (bl2) {
                    this.log.debug("tryNext({}) exhausted all methods - client={}, server={}", new Object[]{clientSession, this.clientMethods, this.serverMethods});
                }
                authFuture.setException(new SshException(14, "No more authentication methods available"));
                return;
            }
            authFuture.setCancellable(false);
            if (authFuture.isCanceled()) {
                authFuture.getCancellation().setCanceled();
                this.clearUserAuth();
                return;
            }
            this.userAuth = (UserAuth)UserAuthMethodFactory.createUserAuth(clientSession, this.authFactories, string);
            if (this.userAuth == null) {
                throw new UnsupportedOperationException("Failed to find a user-auth factory for method=" + string);
            }
            if (bl2) {
                this.log.debug("tryNext({}) attempting method={}", (Object)clientSession, (Object)string);
            }
            this.userAuth.init(clientSession, this.service);
            authFuture.setCancellable(this.userAuth.isCancellable());
            if (authFuture.isCanceled()) {
                authFuture.getCancellation().setCanceled();
                this.clearUserAuth();
            }
            bl2 = this.log.isDebugEnabled();
        }
    }

    private void clearUserAuth() {
        if (this.userAuth != null) {
            try {
                this.userAuth.destroy();
            }
            finally {
                this.userAuth = null;
            }
        }
    }

    @Override
    protected void preClose() {
        AuthFuture authFuture = (AuthFuture)this.authFutureHolder.get();
        if (authFuture != null) {
            authFuture.setException(new SshException("Session is closed"));
        }
        super.preClose();
    }
}

