/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.client.session.ClientSession$ClientSessionEvent;
import org.apache.sshd.client.session.ClientSessionImpl$Services;
import org.apache.sshd.client.session.ClientUserAuthService;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.session.SessionListener$Event;
import org.apache.sshd.common.session.helpers.CurrentService;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class ClientSessionImpl
extends AbstractClientSession {
    private volatile AuthFuture authFuture;
    private final AtomicReference beforeAuthErrorHolder = new AtomicReference();
    private final AtomicReference authErrorHolder = new AtomicReference();
    private final AtomicBoolean initialServiceRequestSent = new AtomicBoolean();
    private Map metadataMap = new HashMap();

    public ClientSessionImpl(ClientFactoryManager clientFactoryManager, IoSession ioSession) {
        super(clientFactoryManager, ioSession);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Client session created: {}", (Object)ioSession);
        }
        this.getCurrentServices().initialize(clientFactoryManager.getServiceFactories());
        this.signalSessionCreated(ioSession);
        this.initializeProxyConnector();
        if (this.sendImmediateClientIdentification) {
            this.sendClientIdentification();
            if (this.sendImmediateKexInit) {
                this.initializeKeyExchangePhase();
            }
        }
    }

    @Override
    protected CurrentService initializeCurrentService() {
        return new ClientSessionImpl$Services(this);
    }

    private ClientSessionImpl$Services getCurrentServices() {
        return (ClientSessionImpl$Services)this.currentService;
    }

    @Override
    protected List getServices() {
        ClientSessionImpl$Services clientSessionImpl$Services = this.getCurrentServices();
        Service service = clientSessionImpl$Services.getNext();
        if (service != null) {
            return Arrays.asList(clientSessionImpl$Services.getService(), service);
        }
        return super.getServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthFuture auth() {
        Throwable throwable;
        AuthFuture authFuture;
        if (this.getUsername() == null) {
            throw new IllegalStateException("No username specified when the session was created");
        }
        ClientUserAuthService clientUserAuthService = this.getUserAuthService();
        String string = this.nextServiceName();
        AtomicReference atomicReference = this.authErrorHolder;
        synchronized (atomicReference) {
            authFuture = (AuthFuture)ValidateUtils.checkNotNull((Object)clientUserAuthService.auth(string), "No auth future generated by service=%s", (Object)string);
            Throwable throwable2 = (Throwable)this.beforeAuthErrorHolder.get();
            throwable = this.authFuture != null ? this.authErrorHolder.getAndSet(throwable2) : throwable2;
            this.authFuture = authFuture;
        }
        if (throwable != null) {
            authFuture.setException(throwable);
            if (this.log.isDebugEnabled()) {
                this.log.debug("auth({}) early exception type={}: {}", new Object[]{this, throwable.getClass().getSimpleName(), throwable.getMessage()});
            }
        }
        return authFuture;
    }

    @Override
    public void exceptionCaught(Throwable throwable) {
        this.signalAuthFailure(throwable);
        super.exceptionCaught(throwable);
    }

    @Override
    protected void preClose() {
        this.signalAuthFailure(new SshException("Session is being closed"));
        super.preClose();
    }

    @Override
    protected void handleDisconnect(int n2, String string, String string2, Buffer buffer) {
        this.signalAuthFailure(new SshException(n2, string));
        super.handleDisconnect(n2, string, string2, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signalAuthFailure(Throwable throwable) {
        AuthFuture authFuture = this.authFuture;
        boolean bl2 = false;
        if (authFuture == null) {
            AtomicReference atomicReference = this.authErrorHolder;
            synchronized (atomicReference) {
                bl2 = this.authErrorHolder.compareAndSet(null, throwable);
                authFuture = this.authFuture;
                if (authFuture == null) {
                    this.beforeAuthErrorHolder.compareAndSet(null, throwable);
                }
            }
        }
        if (authFuture != null) {
            authFuture.setException(throwable);
        }
        if (this.log.isDebugEnabled()) {
            boolean bl3 = authFuture != null && throwable == authFuture.getException();
            this.log.debug("signalAuthFailure({}) type={}, signalled={}, first={}: {}", new Object[]{this, throwable.getClass().getSimpleName(), bl3, bl2, throwable.getMessage()});
        }
    }

    protected String nextServiceName() {
        return this.getCurrentServices().getNextName();
    }

    public void switchToNextService() {
        this.getCurrentServices().switchServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void signalSessionEvent(SessionListener$Event sessionListener$Event) {
        if (SessionListener$Event.KeyEstablished.equals((Object)sessionListener$Event)) {
            this.sendInitialServiceRequest();
        }
        Object object = this.futureLock;
        synchronized (object) {
            this.futureLock.notifyAll();
        }
        super.signalSessionEvent(sessionListener$Event);
    }

    protected void sendInitialServiceRequest() {
        if (this.initialServiceRequestSent.getAndSet(true)) {
            return;
        }
        ClientSessionImpl$Services clientSessionImpl$Services = this.getCurrentServices();
        String string = clientSessionImpl$Services.getName();
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendInitialServiceRequest({}) Send SSH_MSG_SERVICE_REQUEST for {}", (Object)this, (Object)string);
        }
        Buffer buffer = this.createBuffer((byte)5, string.length() + 8);
        buffer.putString(string);
        this.writePacket(buffer);
        clientSessionImpl$Services.start();
    }

    @Override
    public Set waitFor(Collection collection, long l2) {
        Objects.requireNonNull(collection, "No mask specified");
        boolean bl2 = this.log.isTraceEnabled();
        long l3 = System.currentTimeMillis();
        Object object = this.futureLock;
        synchronized (object) {
            long l4 = l2;
            EnumSet<ClientSession$ClientSessionEvent> enumSet = EnumSet.noneOf(ClientSession$ClientSessionEvent.class);
            while (true) {
                block16: {
                    long l5;
                    long l6;
                    this.updateCurrentSessionState(enumSet);
                    boolean bl3 = Collections.disjoint(enumSet, collection);
                    if (!bl3) {
                        if (bl2) {
                            this.log.trace("waitFor({}) call return mask={}, cond={}", new Object[]{this, collection, enumSet});
                        }
                        return enumSet;
                    }
                    if (l2 > 0L && ((l6 = (l5 = System.currentTimeMillis()) - l3) >= l2 || l4 <= 0L)) {
                        if (bl2) {
                            this.log.trace("waitFor({}) call timeout {}/{} for mask={}: {}", new Object[]{this, l6, l2, collection, enumSet});
                        }
                        enumSet.add(ClientSession$ClientSessionEvent.TIMEOUT);
                        return enumSet;
                    }
                    if (bl2) {
                        this.log.trace("waitFor({}) Waiting {} millis for lock on mask={}, cond={}", new Object[]{this, l2, collection, enumSet});
                    }
                    l5 = System.nanoTime();
                    try {
                        if (l2 > 0L) {
                            this.futureLock.wait(l4);
                        } else {
                            this.futureLock.wait();
                        }
                        l6 = System.nanoTime();
                        long l7 = l6 - l5;
                        if (bl2) {
                            this.log.trace("waitFor({}) Lock notified after {} nanos", (Object)this, (Object)l7);
                        }
                        if (l2 > 0L) {
                            long l8 = TimeUnit.MILLISECONDS.convert(l7, TimeUnit.NANOSECONDS);
                            if (l8 <= 0L) {
                                l8 = 123L;
                            }
                            l4 -= l8;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        long l9 = System.nanoTime();
                        long l10 = l9 - l5;
                        if (!bl2) break block16;
                        this.log.trace("waitFor({}) mask={} - ignoring interrupted exception after {} nanos", new Object[]{this, collection, l10});
                    }
                }
                enumSet.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getSessionState() {
        EnumSet<ClientSession$ClientSessionEvent> enumSet = EnumSet.noneOf(ClientSession$ClientSessionEvent.class);
        Object object = this.futureLock;
        synchronized (object) {
            return (Set)this.updateCurrentSessionState(enumSet);
        }
    }

    protected Collection updateCurrentSessionState(Collection collection) {
        AuthFuture authFuture;
        if (this.closeFuture.isClosed()) {
            collection.add(ClientSession$ClientSessionEvent.CLOSED);
        }
        if (this.isAuthenticated()) {
            collection.add(ClientSession$ClientSessionEvent.AUTHED);
        }
        if (KexState.DONE.equals(this.kexState.get()) && ((authFuture = this.authFuture) == null || authFuture.isFailure())) {
            collection.add(ClientSession$ClientSessionEvent.WAIT_AUTH);
        }
        return collection;
    }

    @Override
    public Map getMetadataMap() {
        return this.metadataMap;
    }
}

