/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.security.PublicKey;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.client.ClientAuthenticationManager;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.client.channel.ChannelDirectTcpip;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ChannelSubsystem;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.session.ClientProxyConnectorHolder;
import org.apache.sshd.client.session.forward.DynamicPortForwardingTracker;
import org.apache.sshd.client.session.forward.ExplicitPortForwardingTracker;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.channel.PtyChannelConfigurationHolder;
import org.apache.sshd.common.forward.PortForwardingManager;
import org.apache.sshd.common.future.KeyExchangeFuture;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.io.output.NoCloseOutputStream;
import org.apache.sshd.common.util.io.output.NullOutputStream;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public interface ClientSession
extends ClientAuthenticationManager,
ClientProxyConnectorHolder,
PortForwardingManager,
Session {
    public static final Set REMOTE_COMMAND_WAIT_EVENTS = Collections.unmodifiableSet(EnumSet.of(ClientChannelEvent.CLOSED));

    public SocketAddress getConnectAddress();

    public AttributeRepository getConnectionContext();

    public AuthFuture auth();

    public PublicKey getServerKey();

    public ClientChannel createChannel(String var1);

    public ClientChannel createChannel(String var1, String var2);

    default public ChannelShell createShellChannel() {
        return this.createShellChannel(null, Collections.emptyMap());
    }

    public ChannelShell createShellChannel(PtyChannelConfigurationHolder var1, Map var2);

    default public ChannelExec createExecChannel(String string) {
        return this.createExecChannel(string, null, Collections.emptyMap());
    }

    default public ChannelExec createExecChannel(String string, PtyChannelConfigurationHolder ptyChannelConfigurationHolder, Map map) {
        return this.createExecChannel(string, StandardCharsets.UTF_8, ptyChannelConfigurationHolder, map);
    }

    public ChannelExec createExecChannel(String var1, Charset var2, PtyChannelConfigurationHolder var3, Map var4);

    public ChannelExec createExecChannel(byte[] var1, PtyChannelConfigurationHolder var2, Map var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String executeRemoteCommand(String string) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            String string2;
            block9: {
                try {
                    string2 = this.executeRemoteCommand(string, byteArrayOutputStream, StandardCharsets.US_ASCII);
                    if (byteArrayOutputStream.size() <= 0) break block9;
                }
                catch (Throwable throwable) {
                    if (byteArrayOutputStream.size() > 0) {
                        String string3 = byteArrayOutputStream.toString(StandardCharsets.US_ASCII.name());
                        throw new RemoteException("Error reported from remote command=" + string, new ServerException(string3));
                    }
                    throw throwable;
                }
                String string4 = byteArrayOutputStream.toString(StandardCharsets.US_ASCII.name());
                throw new RemoteException("Error reported from remote command=" + string, new ServerException(string4));
            }
            return string2;
        }
    }

    default public String executeRemoteCommand(String string, OutputStream outputStream, Charset charset) {
        if (charset == null) {
            charset = StandardCharsets.US_ASCII;
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(127);){
            this.executeRemoteCommand(string, byteArrayOutputStream, outputStream, charset);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            String string2 = new String(byArray, charset);
            return string2;
        }
    }

    default public void executeRemoteCommand(String string, OutputStream outputStream, OutputStream outputStream2, Charset charset) {
        if (charset == null) {
            charset = StandardCharsets.US_ASCII;
        }
        try (OutputStream outputStream3 = outputStream2 == null ? new NullOutputStream() : new NoCloseOutputStream(outputStream2);
             OutputStream outputStream4 = outputStream == null ? new NullOutputStream() : new NoCloseOutputStream(outputStream);
             ChannelExec channelExec = this.createExecChannel(string);){
            channelExec.setOut(outputStream4);
            channelExec.setErr(outputStream3);
            channelExec.open().await();
            Set set = channelExec.waitFor((Collection)REMOTE_COMMAND_WAIT_EVENTS, 0L);
            if (set.contains((Object)ClientChannelEvent.TIMEOUT)) {
                throw new SocketTimeoutException("Failed to retrieve command result in time: " + string);
            }
            Integer n2 = channelExec.getExitStatus();
            ClientChannel.validateCommandExitStatusCode(string, n2);
        }
    }

    public ChannelSubsystem createSubsystemChannel(String var1);

    public ChannelDirectTcpip createDirectTcpipChannel(SshdSocketAddress var1, SshdSocketAddress var2);

    default public ExplicitPortForwardingTracker createLocalPortForwardingTracker(int n2, SshdSocketAddress sshdSocketAddress) {
        return this.createLocalPortForwardingTracker(new SshdSocketAddress(n2), sshdSocketAddress);
    }

    default public ExplicitPortForwardingTracker createLocalPortForwardingTracker(SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2) {
        return new ExplicitPortForwardingTracker(this, true, sshdSocketAddress, sshdSocketAddress2, this.startLocalPortForwarding(sshdSocketAddress, sshdSocketAddress2));
    }

    default public ExplicitPortForwardingTracker createRemotePortForwardingTracker(SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2) {
        return new ExplicitPortForwardingTracker(this, false, sshdSocketAddress2, sshdSocketAddress, this.startRemotePortForwarding(sshdSocketAddress, sshdSocketAddress2));
    }

    default public DynamicPortForwardingTracker createDynamicPortForwardingTracker(SshdSocketAddress sshdSocketAddress) {
        return new DynamicPortForwardingTracker(this, sshdSocketAddress, this.startDynamicPortForwarding(sshdSocketAddress));
    }

    public Set getSessionState();

    public Set waitFor(Collection var1, long var2);

    default public Set waitFor(Collection collection, Duration duration) {
        return this.waitFor(collection, duration != null ? duration.toMillis() : -1L);
    }

    public Map getMetadataMap();

    @Override
    public ClientFactoryManager getFactoryManager();

    public KeyExchangeFuture switchToNoneCipher();

    public static KeyIdentityProvider providerOf(ClientSession clientSession) {
        return clientSession == null ? KeyIdentityProvider.EMPTY_KEYS_PROVIDER : KeyIdentityProvider.resolveKeyIdentityProvider(clientSession.getRegisteredIdentities(), clientSession.getKeyIdentityProvider());
    }

    public static Iterator passwordIteratorOf(ClientSession clientSession) {
        return clientSession == null ? Collections.emptyIterator() : PasswordIdentityProvider.iteratorOf(clientSession, clientSession.getRegisteredIdentities(), clientSession.getPasswordIdentityProvider());
    }
}

