/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.auth.AuthenticationIdentitiesProvider;
import org.apache.sshd.client.auth.hostbased.HostBasedAuthenticationReporter;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordAuthenticationReporter;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.client.auth.pubkey.PublicKeyAuthenticationReporter;
import org.apache.sshd.client.channel.ChannelDirectTcpip;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ChannelSubsystem;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientProxyConnector;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionCreator;
import org.apache.sshd.client.session.ClientUserAuthService;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.PtyChannelConfigurationHolder;
import org.apache.sshd.common.cipher.BuiltinCiphers$Constants;
import org.apache.sshd.common.cipher.CipherNone;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.forward.Forwarder;
import org.apache.sshd.common.future.DefaultKeyExchangeFuture;
import org.apache.sshd.common.future.KeyExchangeFuture;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.kex.extension.KexExtensionHandler$AvailabilityPhase;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.session.helpers.AbstractConnectionService;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.core.CoreModuleProperties;

public abstract class AbstractClientSession
extends AbstractSession
implements ClientSession {
    protected final boolean sendImmediateClientIdentification;
    protected final boolean sendImmediateKexInit;
    private final List identities = new CopyOnWriteArrayList();
    private final AuthenticationIdentitiesProvider identitiesProvider;
    private final AttributeRepository connectionContext;
    private PublicKey serverKey;
    private ServerKeyVerifier serverKeyVerifier;
    private UserInteraction userInteraction;
    private PasswordIdentityProvider passwordIdentityProvider;
    private PasswordAuthenticationReporter passwordAuthenticationReporter;
    private KeyIdentityProvider keyIdentityProvider;
    private PublicKeyAuthenticationReporter publicKeyAuthenticationReporter;
    private HostBasedAuthenticationReporter hostBasedAuthenticationReporter;
    private List userAuthFactories;
    private SocketAddress connectAddress;
    private ClientProxyConnector proxyConnector;

    protected AbstractClientSession(ClientFactoryManager clientFactoryManager, IoSession ioSession) {
        super(false, clientFactoryManager, ioSession);
        this.sendImmediateClientIdentification = (Boolean)CoreModuleProperties.SEND_IMMEDIATE_IDENTIFICATION.getRequired(this);
        this.sendImmediateKexInit = (Boolean)CoreModuleProperties.SEND_IMMEDIATE_KEXINIT.getRequired(this);
        this.identitiesProvider = AuthenticationIdentitiesProvider.wrapIdentities(this.identities);
        this.connectionContext = (AttributeRepository)ioSession.getAttribute(AttributeRepository.class);
    }

    @Override
    public AttributeRepository getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public ClientFactoryManager getFactoryManager() {
        return (ClientFactoryManager)super.getFactoryManager();
    }

    @Override
    public SocketAddress getConnectAddress() {
        return this.resolvePeerAddress(this.connectAddress);
    }

    public void setConnectAddress(SocketAddress socketAddress) {
        this.connectAddress = socketAddress;
    }

    @Override
    public PublicKey getServerKey() {
        return this.serverKey;
    }

    public void setServerKey(PublicKey publicKey) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setServerKey({}) keyType={}, digest={}", new Object[]{this, KeyUtils.getKeyType(publicKey), KeyUtils.getFingerPrint(publicKey)});
        }
        this.serverKey = publicKey;
    }

    @Override
    public ServerKeyVerifier getServerKeyVerifier() {
        ClientFactoryManager clientFactoryManager = this.getFactoryManager();
        return (ServerKeyVerifier)this.resolveEffectiveProvider(ServerKeyVerifier.class, this.serverKeyVerifier, clientFactoryManager.getServerKeyVerifier());
    }

    @Override
    public void setServerKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
        this.serverKeyVerifier = serverKeyVerifier;
    }

    @Override
    public UserInteraction getUserInteraction() {
        ClientFactoryManager clientFactoryManager = this.getFactoryManager();
        return (UserInteraction)this.resolveEffectiveProvider(UserInteraction.class, this.userInteraction, clientFactoryManager.getUserInteraction());
    }

    @Override
    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    @Override
    public PasswordAuthenticationReporter getPasswordAuthenticationReporter() {
        ClientFactoryManager clientFactoryManager = this.getFactoryManager();
        return (PasswordAuthenticationReporter)this.resolveEffectiveProvider(PasswordAuthenticationReporter.class, this.passwordAuthenticationReporter, clientFactoryManager.getPasswordAuthenticationReporter());
    }

    @Override
    public void setPasswordAuthenticationReporter(PasswordAuthenticationReporter passwordAuthenticationReporter) {
        this.passwordAuthenticationReporter = passwordAuthenticationReporter;
    }

    @Override
    public List getUserAuthFactories() {
        ClientFactoryManager clientFactoryManager = this.getFactoryManager();
        return (List)this.resolveEffectiveFactories(this.userAuthFactories, clientFactoryManager.getUserAuthFactories());
    }

    @Override
    public void setUserAuthFactories(List list) {
        this.userAuthFactories = list;
    }

    @Override
    public AuthenticationIdentitiesProvider getRegisteredIdentities() {
        return this.identitiesProvider;
    }

    @Override
    public PasswordIdentityProvider getPasswordIdentityProvider() {
        ClientFactoryManager clientFactoryManager = this.getFactoryManager();
        return (PasswordIdentityProvider)this.resolveEffectiveProvider(PasswordIdentityProvider.class, this.passwordIdentityProvider, clientFactoryManager.getPasswordIdentityProvider());
    }

    @Override
    public void setPasswordIdentityProvider(PasswordIdentityProvider passwordIdentityProvider) {
        this.passwordIdentityProvider = passwordIdentityProvider;
    }

    @Override
    public KeyIdentityProvider getKeyIdentityProvider() {
        ClientFactoryManager clientFactoryManager = this.getFactoryManager();
        return (KeyIdentityProvider)this.resolveEffectiveProvider(KeyIdentityProvider.class, this.keyIdentityProvider, clientFactoryManager.getKeyIdentityProvider());
    }

    @Override
    public void setKeyIdentityProvider(KeyIdentityProvider keyIdentityProvider) {
        this.keyIdentityProvider = keyIdentityProvider;
    }

    @Override
    public PublicKeyAuthenticationReporter getPublicKeyAuthenticationReporter() {
        ClientFactoryManager clientFactoryManager = this.getFactoryManager();
        return (PublicKeyAuthenticationReporter)this.resolveEffectiveProvider(PublicKeyAuthenticationReporter.class, this.publicKeyAuthenticationReporter, clientFactoryManager.getPublicKeyAuthenticationReporter());
    }

    @Override
    public void setPublicKeyAuthenticationReporter(PublicKeyAuthenticationReporter publicKeyAuthenticationReporter) {
        this.publicKeyAuthenticationReporter = publicKeyAuthenticationReporter;
    }

    @Override
    public HostBasedAuthenticationReporter getHostBasedAuthenticationReporter() {
        ClientFactoryManager clientFactoryManager = this.getFactoryManager();
        return (HostBasedAuthenticationReporter)this.resolveEffectiveProvider(HostBasedAuthenticationReporter.class, this.hostBasedAuthenticationReporter, clientFactoryManager.getHostBasedAuthenticationReporter());
    }

    @Override
    public void setHostBasedAuthenticationReporter(HostBasedAuthenticationReporter hostBasedAuthenticationReporter) {
        this.hostBasedAuthenticationReporter = hostBasedAuthenticationReporter;
    }

    @Override
    public ClientProxyConnector getClientProxyConnector() {
        ClientFactoryManager clientFactoryManager = this.getFactoryManager();
        return (ClientProxyConnector)this.resolveEffectiveProvider(ClientProxyConnector.class, this.proxyConnector, clientFactoryManager.getClientProxyConnector());
    }

    @Override
    public void setClientProxyConnector(ClientProxyConnector clientProxyConnector) {
        this.proxyConnector = clientProxyConnector;
    }

    @Override
    public void addPasswordIdentity(String string) {
        ValidateUtils.checkTrue(string != null && !string.isEmpty(), "No password provided");
        this.identities.add(string);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPasswordIdentity({}) {}", (Object)this, (Object)KeyUtils.getFingerPrint(string));
        }
    }

    @Override
    public String removePasswordIdentity(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        int n2 = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.PASSWORD_IDENTITY_COMPARATOR, string);
        if (n2 >= 0) {
            return (String)this.identities.remove(n2);
        }
        return null;
    }

    @Override
    public void addPublicKeyIdentity(KeyPair keyPair) {
        Objects.requireNonNull(keyPair, "No key-pair to add");
        Objects.requireNonNull(keyPair.getPublic(), "No public key");
        Objects.requireNonNull(keyPair.getPrivate(), "No private key");
        this.identities.add(keyPair);
        if (this.log.isDebugEnabled()) {
            PublicKey publicKey = keyPair.getPublic();
            this.log.debug("addPublicKeyIdentity({}) {}-{}", new Object[]{this, KeyUtils.getKeyType(publicKey), KeyUtils.getFingerPrint(publicKey)});
        }
    }

    @Override
    public KeyPair removePublicKeyIdentity(KeyPair keyPair) {
        if (keyPair == null) {
            return null;
        }
        int n2 = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.KEYPAIR_IDENTITY_COMPARATOR, keyPair);
        if (n2 >= 0) {
            return (KeyPair)this.identities.remove(n2);
        }
        return null;
    }

    protected void initializeKeyExchangePhase() {
        KexExtensionHandler kexExtensionHandler = this.getKexExtensionHandler();
        if (kexExtensionHandler == null || !kexExtensionHandler.isKexExtensionsAvailable(this, KexExtensionHandler$AvailabilityPhase.PREKEX)) {
            this.kexState.set(KexState.INIT);
            this.sendKexInit();
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("initializeKexPhase({}) delay KEX-INIT until server-side one received", (Object)this);
        }
    }

    protected void initializeProxyConnector() {
        ClientProxyConnector clientProxyConnector = this.getClientProxyConnector();
        boolean bl2 = this.log.isDebugEnabled();
        if (clientProxyConnector == null) {
            if (bl2) {
                this.log.debug("initializeProxyConnector({}) no proxy to initialize", (Object)this);
            }
            return;
        }
        try {
            if (bl2) {
                this.log.debug("initializeProxyConnector({}) initialize proxy={}", (Object)this, (Object)clientProxyConnector);
            }
            clientProxyConnector.sendClientProxyMetadata(this);
            if (bl2) {
                this.log.debug("initializeProxyConnector({}) proxy={} initialized", (Object)this, (Object)clientProxyConnector);
            }
        }
        catch (Throwable throwable) {
            this.warn("initializeProxyConnector({}) failed ({}) to send proxy metadata: {}", this, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new RuntimeSshException(throwable);
        }
    }

    protected IoWriteFuture sendClientIdentification() {
        this.clientVersion = this.resolveIdentificationString(CoreModuleProperties.CLIENT_IDENTIFICATION.getName());
        this.signalSendIdentification(this.clientVersion, Collections.emptyList());
        return this.sendIdentification(this.clientVersion, Collections.emptyList());
    }

    @Override
    public ClientChannel createChannel(String string) {
        return this.createChannel(string, null);
    }

    @Override
    public ClientChannel createChannel(String string, String string2) {
        if ("shell".equals(string)) {
            return this.createShellChannel();
        }
        if ("exec".equals(string)) {
            return this.createExecChannel(string2);
        }
        if ("subsystem".equals(string)) {
            return this.createSubsystemChannel(string2);
        }
        throw new IllegalArgumentException("Unsupported channel type requested: " + string);
    }

    @Override
    public ChannelExec createExecChannel(String string, Charset charset, PtyChannelConfigurationHolder ptyChannelConfigurationHolder, Map map) {
        ChannelExec channelExec = new ChannelExec(string, charset, ptyChannelConfigurationHolder, map);
        ConnectionService connectionService = this.getConnectionService();
        long l2 = connectionService.registerChannel(channelExec);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createExecChannel({})[{}] created id={} - PTY={}", new Object[]{this, string, l2, ptyChannelConfigurationHolder});
        }
        return channelExec;
    }

    @Override
    public ChannelExec createExecChannel(byte[] byArray, PtyChannelConfigurationHolder ptyChannelConfigurationHolder, Map map) {
        ChannelExec channelExec = new ChannelExec(byArray, ptyChannelConfigurationHolder, map);
        ConnectionService connectionService = this.getConnectionService();
        long l2 = connectionService.registerChannel(channelExec);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createExecChannel({})[{}] created id={} - PTY={}", new Object[]{this, new String(byArray, StandardCharsets.UTF_8), l2, ptyChannelConfigurationHolder});
        }
        return channelExec;
    }

    @Override
    public ChannelSubsystem createSubsystemChannel(String string) {
        ChannelSubsystem channelSubsystem = new ChannelSubsystem(string);
        ConnectionService connectionService = this.getConnectionService();
        long l2 = connectionService.registerChannel(channelSubsystem);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createSubsystemChannel({})[{}] created id={}", new Object[]{this, string, l2});
        }
        return channelSubsystem;
    }

    @Override
    public ChannelDirectTcpip createDirectTcpipChannel(SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2) {
        ChannelDirectTcpip channelDirectTcpip = new ChannelDirectTcpip(sshdSocketAddress, sshdSocketAddress2);
        ConnectionService connectionService = this.getConnectionService();
        long l2 = connectionService.registerChannel(channelDirectTcpip);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createDirectTcpipChannel({})[{} => {}] created id={}", new Object[]{this, sshdSocketAddress, sshdSocketAddress2, l2});
        }
        return channelDirectTcpip;
    }

    protected ClientUserAuthService getUserAuthService() {
        return (ClientUserAuthService)this.getService(ClientUserAuthService.class);
    }

    @Override
    protected ConnectionService getConnectionService() {
        return (ConnectionService)this.getService(ConnectionService.class);
    }

    @Override
    public SshdSocketAddress startLocalPortForwarding(SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2) {
        Forwarder forwarder = this.getForwarder();
        return forwarder.startLocalPortForwarding(sshdSocketAddress, sshdSocketAddress2);
    }

    @Override
    public void stopLocalPortForwarding(SshdSocketAddress sshdSocketAddress) {
        Forwarder forwarder = this.getForwarder();
        forwarder.stopLocalPortForwarding(sshdSocketAddress);
    }

    @Override
    public SshdSocketAddress startRemotePortForwarding(SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2) {
        Forwarder forwarder = this.getForwarder();
        return forwarder.startRemotePortForwarding(sshdSocketAddress, sshdSocketAddress2);
    }

    @Override
    public void stopRemotePortForwarding(SshdSocketAddress sshdSocketAddress) {
        Forwarder forwarder = this.getForwarder();
        forwarder.stopRemotePortForwarding(sshdSocketAddress);
    }

    @Override
    public SshdSocketAddress startDynamicPortForwarding(SshdSocketAddress sshdSocketAddress) {
        Forwarder forwarder = this.getForwarder();
        return forwarder.startDynamicPortForwarding(sshdSocketAddress);
    }

    @Override
    public void stopDynamicPortForwarding(SshdSocketAddress sshdSocketAddress) {
        Forwarder forwarder = this.getForwarder();
        forwarder.stopDynamicPortForwarding(sshdSocketAddress);
    }

    @Override
    protected Forwarder getForwarder() {
        ConnectionService connectionService = Objects.requireNonNull(this.getConnectionService(), "No connection service");
        return Objects.requireNonNull(connectionService.getForwarder(), "No forwarder");
    }

    @Override
    protected String resolveAvailableSignaturesProposal(FactoryManager factoryManager) {
        ValidateUtils.checkTrue(factoryManager == this.getFactoryManager(), "Mismatched factory manager instances");
        return NamedResource.getNames(this.getSignatureFactories());
    }

    @Override
    public void startService(String string, Buffer buffer) {
        SessionDisconnectHandler sessionDisconnectHandler = this.getSessionDisconnectHandler();
        if (sessionDisconnectHandler != null && sessionDisconnectHandler.handleUnsupportedServiceDisconnectReason(this, 5, string, buffer)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("startService({}) ignore unknown service={} by handler", (Object)this, (Object)string);
            }
            return;
        }
        throw new IllegalStateException("Starting services is not supported on the client side: " + string);
    }

    @Override
    public ChannelShell createShellChannel(PtyChannelConfigurationHolder ptyChannelConfigurationHolder, Map map) {
        if (this.inCipher instanceof CipherNone || this.outCipher instanceof CipherNone) {
            throw new IllegalStateException("Interactive channels are not supported with none cipher");
        }
        ChannelShell channelShell = new ChannelShell(ptyChannelConfigurationHolder, map);
        ConnectionService connectionService = this.getConnectionService();
        long l2 = connectionService.registerChannel(channelShell);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createShellChannel({}) created id={} - PTY={}", new Object[]{this, l2, ptyChannelConfigurationHolder});
        }
        return channelShell;
    }

    @Override
    protected boolean readIdentification(Buffer buffer) {
        List list = this.doReadIdentification(buffer, false);
        int n2 = GenericUtils.size(list);
        String string = this.serverVersion = n2 <= 0 ? null : (String)list.remove(n2 - 1);
        if (this.serverVersion == null) {
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("readIdentification({}) Server version string: {}", (Object)this, (Object)this.serverVersion);
        }
        if (!SessionContext.isValidVersionPrefix(this.serverVersion)) {
            throw new SshException(8, "Unsupported protocol version: " + this.serverVersion);
        }
        this.signalExtraServerVersionInfo(this.serverVersion, list);
        if (!this.sendImmediateClientIdentification) {
            this.sendClientIdentification();
            this.initializeKeyExchangePhase();
        } else if (!this.sendImmediateKexInit) {
            this.initializeKeyExchangePhase();
        }
        return true;
    }

    protected void signalExtraServerVersionInfo(String string, List list) {
        this.signalPeerIdentificationReceived(string, list);
        if (GenericUtils.isEmpty(list)) {
            return;
        }
        UserInteraction userInteraction = this.getUserInteraction();
        try {
            if (userInteraction != null && userInteraction.isInteractionAllowed(this)) {
                userInteraction.serverVersionInfo(this, list);
            }
        }
        catch (Error error) {
            this.warn("signalExtraServerVersionInfo({})[{}] failed ({}) to consult interaction: {}", this, string, error.getClass().getSimpleName(), error.getMessage(), error);
            throw new RuntimeSshException(error);
        }
    }

    @Override
    protected byte[] sendKexInit(Map map) {
        this.mergeProposals(this.clientProposal, map);
        return super.sendKexInit(map);
    }

    @Override
    protected void setKexSeed(byte ... byArray) {
        this.setClientKexData(byArray);
    }

    @Override
    protected byte[] receiveKexInit(Buffer buffer) {
        byte[] byArray = super.receiveKexInit(buffer);
        if (this.kexState.compareAndSet(KexState.UNKNOWN, KexState.RUN)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("receiveKexInit({}) sending client proposal", (Object)this);
            }
            this.kexState.set(KexState.INIT);
            this.sendKexInit();
        }
        return byArray;
    }

    @Override
    protected void receiveKexInit(Map map, byte[] byArray) {
        this.mergeProposals(this.serverProposal, map);
        this.setServerKexData(byArray);
    }

    @Override
    protected void checkKeys() {
        ServerKeyVerifier serverKeyVerifier = Objects.requireNonNull(this.getServerKeyVerifier(), "No server key verifier");
        IoSession ioSession = this.getIoSession();
        SocketAddress socketAddress = ioSession.getRemoteAddress();
        PublicKey publicKey = Objects.requireNonNull(this.getServerKey(), "No server key to verify");
        SshdSocketAddress sshdSocketAddress = (SshdSocketAddress)this.getAttribute(ClientSessionCreator.TARGET_SERVER);
        if (sshdSocketAddress != null) {
            socketAddress = sshdSocketAddress.toInetSocketAddress();
        }
        boolean bl2 = false;
        if (publicKey instanceof OpenSshCertificate) {
            bl2 = serverKeyVerifier.verifyServerKey(this, socketAddress, ((OpenSshCertificate)publicKey).getCaPubKey());
            if (this.log.isDebugEnabled()) {
                this.log.debug("checkCA({}) key={}-{}, verified={}", new Object[]{this, KeyUtils.getKeyType(publicKey), KeyUtils.getFingerPrint(publicKey), bl2});
            }
            if (!bl2) {
                publicKey = ((OpenSshCertificate)publicKey).getCertPubKey();
            }
        }
        if (!bl2) {
            bl2 = serverKeyVerifier.verifyServerKey(this, socketAddress, publicKey);
            if (this.log.isDebugEnabled()) {
                this.log.debug("checkKeys({}) key={}-{}, verified={}", new Object[]{this, KeyUtils.getKeyType(publicKey), KeyUtils.getFingerPrint(publicKey), bl2});
            }
        }
        if (!bl2) {
            throw new SshException(9, "Server key did not validate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyExchangeFuture switchToNoneCipher() {
        Service service = this.currentService.getService();
        if (!(service instanceof AbstractConnectionService) || !GenericUtils.isEmpty(((AbstractConnectionService)service).getChannels())) {
            throw new IllegalStateException("The switch to the none cipher must be done immediately after authentication");
        }
        if (this.kexState.compareAndSet(KexState.DONE, KexState.INIT)) {
            String string;
            String string2;
            String string3;
            String string4;
            DefaultKeyExchangeFuture defaultKeyExchangeFuture = new DefaultKeyExchangeFuture(this.toString(), null);
            DefaultKeyExchangeFuture defaultKeyExchangeFuture2 = this.kexFutureHolder.getAndSet(defaultKeyExchangeFuture);
            if (defaultKeyExchangeFuture2 != null) {
                defaultKeyExchangeFuture2.setValue(new SshException("Switch to none cipher while previous KEX is ongoing"));
            }
            Map map = this.serverProposal;
            synchronized (map) {
                string4 = (String)this.serverProposal.get((Object)KexProposalOption.C2SENC);
                string3 = (String)this.serverProposal.get((Object)KexProposalOption.S2CENC);
            }
            boolean bl2 = BuiltinCiphers$Constants.isNoneCipherIncluded(string4);
            boolean bl3 = BuiltinCiphers$Constants.isNoneCipherIncluded(string3);
            Map map2 = this.clientProposal;
            synchronized (map2) {
                string2 = (String)this.clientProposal.get((Object)KexProposalOption.C2SENC);
                string = (String)this.clientProposal.get((Object)KexProposalOption.S2CENC);
            }
            boolean bl4 = BuiltinCiphers$Constants.isNoneCipherIncluded(string2);
            boolean bl5 = BuiltinCiphers$Constants.isNoneCipherIncluded(string);
            if (!bl2 || !bl3) {
                defaultKeyExchangeFuture.setValue(new SshException("Server does not support none cipher"));
            } else if (!bl4 || !bl5) {
                defaultKeyExchangeFuture.setValue(new SshException("Client does not support none cipher"));
            } else {
                this.log.info("switchToNoneCipher({}) switching", (Object)this);
                EnumMap<KexProposalOption, String> enumMap = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
                Object object = this.clientProposal;
                synchronized (object) {
                    enumMap.putAll(this.clientProposal);
                }
                enumMap.put(KexProposalOption.C2SENC, "none");
                enumMap.put(KexProposalOption.S2CENC, "none");
                object = this.kexState;
                synchronized (object) {
                    DefaultKeyExchangeFuture defaultKeyExchangeFuture3 = this.kexInitializedFuture;
                    if (defaultKeyExchangeFuture3 == null) {
                        this.kexInitializedFuture = defaultKeyExchangeFuture3 = new DefaultKeyExchangeFuture(this.toString(), null);
                    }
                    try {
                        byte[] byArray = this.sendKexInit(enumMap);
                        this.setKexSeed(byArray);
                        defaultKeyExchangeFuture3.setValue(Boolean.TRUE);
                    }
                    catch (Exception exception) {
                        defaultKeyExchangeFuture3.setValue(exception);
                        ExceptionUtils.rethrowAsIoException(exception);
                    }
                }
            }
            return Objects.requireNonNull((DefaultKeyExchangeFuture)this.kexFutureHolder.get(), "No current KEX future");
        }
        throw new SshException("In flight key exchange");
    }
}

