/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.keyverifier;

import java.net.SocketAddress;
import java.security.PublicKey;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class StaticServerKeyVerifier
extends AbstractLoggingBean
implements ServerKeyVerifier {
    private final boolean acceptance;

    protected StaticServerKeyVerifier(boolean bl2) {
        this.acceptance = bl2;
    }

    public final boolean isAccepted() {
        return this.acceptance;
    }

    @Override
    public final boolean verifyServerKey(ClientSession clientSession, SocketAddress socketAddress, PublicKey publicKey) {
        boolean bl2 = this.isAccepted();
        if (bl2) {
            this.handleAcceptance(clientSession, socketAddress, publicKey);
        } else {
            this.handleRejection(clientSession, socketAddress, publicKey);
        }
        return bl2;
    }

    protected void handleAcceptance(ClientSession clientSession, SocketAddress socketAddress, PublicKey publicKey) {
        this.log.warn("Server at {} presented unverified {} key: {}", new Object[]{socketAddress, publicKey == null ? null : publicKey.getAlgorithm(), KeyUtils.getFingerPrint(publicKey)});
    }

    protected void handleRejection(ClientSession clientSession, SocketAddress socketAddress, PublicKey publicKey) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Reject server {} unverified {} key: {}", new Object[]{socketAddress, publicKey == null ? null : publicKey.getAlgorithm(), KeyUtils.getFingerPrint(publicKey)});
        }
    }
}

