/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.keyverifier;

import java.net.SocketAddress;
import java.security.PublicKey;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class RequiredServerKeyVerifier
extends AbstractLoggingBean
implements ServerKeyVerifier {
    private final PublicKey requiredKey;

    public RequiredServerKeyVerifier(PublicKey publicKey) {
        this.requiredKey = publicKey;
    }

    public final PublicKey getRequiredKey() {
        return this.requiredKey;
    }

    @Override
    public boolean verifyServerKey(ClientSession clientSession, SocketAddress socketAddress, PublicKey publicKey) {
        if (this.requiredKey.equals(publicKey)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Server at {} presented expected key: {}", (Object)socketAddress, (Object)BufferUtils.toHex(publicKey.getEncoded()));
            }
            return true;
        }
        this.log.error("Server at {} presented wrong key: {}", (Object)socketAddress, (Object)BufferUtils.toHex(publicKey.getEncoded()));
        return false;
    }
}

