/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.keyverifier;

import java.io.BufferedReader;
import java.io.OutputStream;
import java.io.Writer;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.sshd.client.config.hosts.KnownHostEntry;
import org.apache.sshd.client.config.hosts.KnownHostHashValue;
import org.apache.sshd.client.keyverifier.KnownHostsServerKeyVerifier$HostEntryPair;
import org.apache.sshd.client.keyverifier.ModifiedServerKeyAcceptor;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class KnownHostsServerKeyVerifier
extends ModifiableFileWatcher
implements ModifiedServerKeyAcceptor,
ServerKeyVerifier {
    public static final String STRICT_CHECKING_OPTION = "StrictHostKeyChecking";
    public static final String KNOWN_HOSTS_FILE_OPTION = "UserKnownHostsFile";
    protected final Object updateLock = new Object();
    private final ServerKeyVerifier delegate;
    private final AtomicReference keysSupplier = new AtomicReference<Supplier>(this.getKnownHostSupplier(null, this.getPath()));
    private ModifiedServerKeyAcceptor modKeyAcceptor;

    public KnownHostsServerKeyVerifier(ServerKeyVerifier serverKeyVerifier, Path path) {
        this(serverKeyVerifier, path, IoUtils.EMPTY_LINK_OPTIONS);
    }

    public KnownHostsServerKeyVerifier(ServerKeyVerifier serverKeyVerifier, Path path, LinkOption ... linkOptionArray) {
        super(path, linkOptionArray);
        this.delegate = Objects.requireNonNull(serverKeyVerifier, "No delegate");
    }

    public ServerKeyVerifier getDelegateVerifier() {
        return this.delegate;
    }

    public ModifiedServerKeyAcceptor getModifiedServerKeyAcceptor() {
        return this.modKeyAcceptor;
    }

    public void setModifiedServerKeyAcceptor(ModifiedServerKeyAcceptor modifiedServerKeyAcceptor) {
        this.modKeyAcceptor = modifiedServerKeyAcceptor;
    }

    @Override
    public boolean verifyServerKey(ClientSession clientSession, SocketAddress socketAddress, PublicKey publicKey) {
        Iterable<Path> iterable;
        try {
            if (this.checkReloadRequired()) {
                iterable = this.getPath();
                if (this.exists()) {
                    this.updateReloadAttributes();
                    this.keysSupplier.set(GenericUtils.memoizeLock(this.getKnownHostSupplier(clientSession, (Path)iterable)));
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("verifyServerKey({})[{}] missing known hosts file {}", new Object[]{clientSession, socketAddress, iterable});
                    }
                    this.keysSupplier.set(GenericUtils.memoizeLock(Collections::emptyList));
                }
            }
        }
        catch (Throwable throwable) {
            return this.acceptIncompleteHostKeys(clientSession, socketAddress, publicKey, throwable);
        }
        iterable = (Collection)((Supplier)this.keysSupplier.get()).get();
        return this.acceptKnownHostEntries(clientSession, socketAddress, publicKey, (Collection)iterable);
    }

    protected Supplier getKnownHostSupplier(ClientSession clientSession, Path path) {
        return () -> {
            try {
                return this.reloadKnownHosts(clientSession, path);
            }
            catch (Exception exception) {
                this.log.warn("verifyServerKey({}) Could not reload known hosts file {}", new Object[]{clientSession, path, exception});
                return Collections.emptyList();
            }
        };
    }

    protected void setLoadedHostsEntries(Collection collection) {
        this.keysSupplier.set(() -> collection);
    }

    protected List reloadKnownHosts(ClientSession clientSession, Path path) {
        List list = KnownHostEntry.readKnownHostEntries(path, new OpenOption[0]);
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("reloadKnownHosts({}) loaded {} entries", (Object)path, (Object)list.size());
        }
        this.updateReloadAttributes();
        if (GenericUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<KnownHostsServerKeyVerifier$HostEntryPair> arrayList = new ArrayList<KnownHostsServerKeyVerifier$HostEntryPair>(list.size());
        PublicKeyEntryResolver publicKeyEntryResolver = this.getFallbackPublicKeyEntryResolver();
        for (KnownHostEntry knownHostEntry : list) {
            try {
                PublicKey publicKey = this.resolveHostKey(clientSession, knownHostEntry, publicKeyEntryResolver);
                if (publicKey == null) continue;
                arrayList.add(new KnownHostsServerKeyVerifier$HostEntryPair(knownHostEntry, publicKey));
            }
            catch (Throwable throwable) {
                this.warn("reloadKnownHosts({}) failed ({}) to load key of {}: {}", path, throwable.getClass().getSimpleName(), knownHostEntry, throwable.getMessage(), throwable);
            }
        }
        return arrayList;
    }

    protected PublicKey resolveHostKey(ClientSession clientSession, KnownHostEntry knownHostEntry, PublicKeyEntryResolver publicKeyEntryResolver) {
        if (knownHostEntry == null) {
            return null;
        }
        AuthorizedKeyEntry authorizedKeyEntry = (AuthorizedKeyEntry)ValidateUtils.checkNotNull((Object)knownHostEntry.getKeyEntry(), "No key extracted from %s", (Object)knownHostEntry);
        PublicKey publicKey = authorizedKeyEntry.resolvePublicKey(clientSession, publicKeyEntryResolver);
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveHostKey({}) loaded {}-{}", new Object[]{knownHostEntry, KeyUtils.getKeyType(publicKey), KeyUtils.getFingerPrint(publicKey)});
        }
        return publicKey;
    }

    protected PublicKeyEntryResolver getFallbackPublicKeyEntryResolver() {
        return PublicKeyEntryResolver.IGNORING;
    }

    protected boolean acceptKnownHostEntries(ClientSession clientSession, SocketAddress socketAddress, PublicKey publicKey, Collection collection) {
        List list = this.findKnownHostEntries(clientSession, socketAddress, collection);
        if (list.isEmpty()) {
            return this.acceptUnknownHostKey(clientSession, socketAddress, publicKey);
        }
        String string = KeyUtils.getKeyType(publicKey);
        List list2 = list.stream().filter(knownHostsServerKeyVerifier$HostEntryPair -> string.equals(knownHostsServerKeyVerifier$HostEntryPair.getHostEntry().getKeyEntry().getKeyType())).filter(knownHostsServerKeyVerifier$HostEntryPair -> KeyUtils.compareKeys(knownHostsServerKeyVerifier$HostEntryPair.getServerKey(), publicKey)).collect(Collectors.toList());
        if (list2.stream().anyMatch(knownHostsServerKeyVerifier$HostEntryPair -> "revoked".equals(knownHostsServerKeyVerifier$HostEntryPair.getHostEntry().getMarker()))) {
            this.log.debug("acceptKnownHostEntry({})[{}] key={}-{} marked as revoked", new Object[]{clientSession, socketAddress, KeyUtils.getKeyType(publicKey), KeyUtils.getFingerPrint(publicKey)});
            return false;
        }
        if (!list2.isEmpty()) {
            return true;
        }
        Optional<KnownHostsServerKeyVerifier$HostEntryPair> optional = list.stream().filter(knownHostsServerKeyVerifier$HostEntryPair -> !"revoked".equals(knownHostsServerKeyVerifier$HostEntryPair.getHostEntry().getMarker())).findAny();
        if (!optional.isPresent()) {
            return this.acceptUnknownHostKey(clientSession, socketAddress, publicKey);
        }
        KnownHostEntry knownHostEntry = optional.get().getHostEntry();
        PublicKey publicKey2 = optional.get().getServerKey();
        try {
            if (this.acceptModifiedServerKey(clientSession, socketAddress, knownHostEntry, publicKey2, publicKey)) {
                this.updateModifiedServerKey(clientSession, socketAddress, publicKey, collection, optional.get());
                return true;
            }
        }
        catch (Throwable throwable) {
            this.warn("acceptKnownHostEntries({})[{}] failed ({}) to accept modified server key: {}", clientSession, socketAddress, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
        }
        return false;
    }

    protected void updateModifiedServerKey(ClientSession clientSession, SocketAddress socketAddress, PublicKey publicKey, Collection collection, KnownHostsServerKeyVerifier$HostEntryPair knownHostsServerKeyVerifier$HostEntryPair) {
        Path path = this.getPath();
        try {
            this.updateModifiedServerKey(clientSession, socketAddress, knownHostsServerKeyVerifier$HostEntryPair, publicKey, path, collection);
        }
        catch (Throwable throwable) {
            this.handleModifiedServerKeyUpdateFailure(clientSession, socketAddress, knownHostsServerKeyVerifier$HostEntryPair, publicKey, path, collection, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateModifiedServerKey(ClientSession clientSession, SocketAddress socketAddress, KnownHostsServerKeyVerifier$HostEntryPair knownHostsServerKeyVerifier$HostEntryPair, PublicKey publicKey, Path path, Collection collection) {
        String string;
        KnownHostEntry knownHostEntry = knownHostsServerKeyVerifier$HostEntryPair.getHostEntry();
        String string2 = this.prepareModifiedServerKeyLine(clientSession, socketAddress, knownHostEntry, string = ValidateUtils.checkNotNullAndNotEmpty(knownHostEntry.getConfigLine(), "No entry config line"), knownHostsServerKeyVerifier$HostEntryPair.getServerKey(), publicKey);
        if (GenericUtils.isEmpty(string2)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("updateModifiedServerKey({})[{}] no replacement generated for {}", new Object[]{clientSession, socketAddress, string});
            }
            return;
        }
        if (string.equals(string2)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("updateModifiedServerKey({})[{}] unmodified updated line for {}", new Object[]{clientSession, socketAddress, string});
            }
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = this.updateLock;
        synchronized (object) {
            int n2 = -1;
            try (Object object2 = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                Object object3 = ((BufferedReader)object2).readLine();
                while (object3 != null) {
                    if (n2 >= 0) {
                        arrayList.add(object3);
                    } else if (GenericUtils.isEmpty((CharSequence)(object3 = GenericUtils.trimToEmpty((String)object3)))) {
                        arrayList.add(object3);
                    } else {
                        int n3 = ((String)object3).indexOf(35);
                        if (n3 == 0) {
                            arrayList.add(object3);
                        } else {
                            if (n3 > 0) {
                                object3 = ((String)object3).substring(0, n3);
                                object3 = ((String)object3).trim();
                            }
                            if (!string.equals(object3)) {
                                arrayList.add(object3);
                            } else {
                                arrayList.add(string2);
                                n2 = arrayList.size();
                            }
                        }
                    }
                    object3 = ((BufferedReader)object2).readLine();
                }
            }
            ValidateUtils.checkTrue(n2 >= 0, "No match found for line=%s", (Object)string);
            object2 = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
            try {
                for (String string3 : arrayList) {
                    ((Writer)object2).append(string3).append(IoUtils.EOL);
                }
            }
            finally {
                if (object2 != null) {
                    ((Writer)object2).close();
                }
            }
            object2 = knownHostsServerKeyVerifier$HostEntryPair;
            synchronized (object2) {
                knownHostsServerKeyVerifier$HostEntryPair.setServerKey(publicKey);
                knownHostEntry.setConfigLine(string2);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("updateModifiedServerKey({}) replaced '{}' with '{}'", new Object[]{path, string, string2});
        }
        this.resetReloadAttributes();
    }

    protected String prepareModifiedServerKeyLine(ClientSession clientSession, SocketAddress socketAddress, KnownHostEntry knownHostEntry, String string, PublicKey publicKey, PublicKey publicKey2) {
        if (knownHostEntry == null || GenericUtils.isEmpty(string)) {
            return string;
        }
        int n2 = string.indexOf(32);
        if (string.charAt(0) == '@') {
            ++n2;
            while (n2 < string.length() && string.charAt(n2) == ' ') {
                ++n2;
            }
            n2 = n2 < string.length() ? string.indexOf(32, n2) : -1;
        }
        ValidateUtils.checkTrue(n2 > 0 && n2 < string.length() - 1, "Missing encoded key in line=%s", (Object)string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        stringBuilder.append(string.substring(0, n2));
        PublicKeyEntry.appendPublicKeyEntry(stringBuilder.append(' '), publicKey2);
        return stringBuilder.toString();
    }

    protected void handleModifiedServerKeyUpdateFailure(ClientSession clientSession, SocketAddress socketAddress, KnownHostsServerKeyVerifier$HostEntryPair knownHostsServerKeyVerifier$HostEntryPair, PublicKey publicKey, Path path, Collection collection, Throwable throwable) {
        this.warn("acceptKnownHostEntries({})[{}] failed ({}) to update modified server key of {}: {}", clientSession, socketAddress, throwable.getClass().getSimpleName(), knownHostsServerKeyVerifier$HostEntryPair, throwable.getMessage(), throwable);
    }

    protected List findKnownHostEntries(ClientSession clientSession, SocketAddress socketAddress, Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        Collection collection2 = this.resolveHostNetworkIdentities(clientSession, socketAddress);
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("findKnownHostEntries({})[{}] host network identities: {}", new Object[]{clientSession, socketAddress, collection2});
        }
        if (GenericUtils.isEmpty(collection2)) {
            return Collections.emptyList();
        }
        ArrayList<KnownHostsServerKeyVerifier$HostEntryPair> arrayList = new ArrayList<KnownHostsServerKeyVerifier$HostEntryPair>();
        block2: for (KnownHostsServerKeyVerifier$HostEntryPair knownHostsServerKeyVerifier$HostEntryPair : collection) {
            KnownHostEntry knownHostEntry = knownHostsServerKeyVerifier$HostEntryPair.getHostEntry();
            for (SshdSocketAddress sshdSocketAddress : collection2) {
                try {
                    if (!knownHostEntry.isHostMatch(sshdSocketAddress.getHostName(), sshdSocketAddress.getPort())) continue;
                    if (bl2) {
                        this.log.debug("findKnownHostEntries({})[{}] matched host={} for entry={}", new Object[]{clientSession, socketAddress, sshdSocketAddress, knownHostEntry});
                    }
                    arrayList.add(knownHostsServerKeyVerifier$HostEntryPair);
                    continue block2;
                }
                catch (Error | RuntimeException throwable) {
                    this.warn("findKnownHostEntries({})[{}] failed ({}) to check host={} for entry={}: {}", clientSession, socketAddress, throwable.getClass().getSimpleName(), sshdSocketAddress, knownHostEntry.getConfigLine(), throwable.getMessage(), throwable);
                }
            }
        }
        return arrayList;
    }

    protected boolean acceptIncompleteHostKeys(ClientSession clientSession, SocketAddress socketAddress, PublicKey publicKey, Throwable throwable) {
        this.warn("Failed ({}) to reload server keys from {}: {}", throwable.getClass().getSimpleName(), this.getPath(), throwable.getMessage(), throwable);
        return this.acceptUnknownHostKey(clientSession, socketAddress, publicKey);
    }

    protected boolean acceptUnknownHostKey(ClientSession clientSession, SocketAddress socketAddress, PublicKey publicKey) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("acceptUnknownHostKey({}) host={}, key={}", new Object[]{clientSession, socketAddress, KeyUtils.getFingerPrint(publicKey)});
        }
        if (this.delegate.verifyServerKey(clientSession, socketAddress, publicKey)) {
            Path path = this.getPath();
            Collection collection = (Collection)((Supplier)this.keysSupplier.get()).get();
            try {
                this.updateKnownHostsFile(clientSession, socketAddress, publicKey, path, collection);
            }
            catch (Throwable throwable) {
                this.handleKnownHostsFileUpdateFailure(clientSession, socketAddress, publicKey, path, collection, throwable);
            }
            return true;
        }
        return false;
    }

    protected void handleKnownHostsFileUpdateFailure(ClientSession clientSession, SocketAddress socketAddress, PublicKey publicKey, Path path, Collection collection, Throwable throwable) {
        this.warn("handleKnownHostsFileUpdateFailure({})[{}] failed ({}) to update key={}-{} in {}: {}", clientSession, socketAddress, throwable.getClass().getSimpleName(), KeyUtils.getKeyType(publicKey), KeyUtils.getFingerPrint(publicKey), path, throwable.getMessage(), throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KnownHostEntry updateKnownHostsFile(ClientSession clientSession, SocketAddress socketAddress, PublicKey publicKey, Path path, Collection collection) {
        KnownHostEntry knownHostEntry = this.prepareKnownHostEntry(clientSession, socketAddress, publicKey);
        if (knownHostEntry == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("updateKnownHostsFile({})[{}] no entry generated for key={}", new Object[]{clientSession, socketAddress, KeyUtils.getFingerPrint(publicKey)});
            }
            return null;
        }
        String string = knownHostEntry.getConfigLine();
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        boolean bl2 = Files.exists(path, new LinkOption[0]) && Files.size(path) > 0L;
        byte[] byArray2 = IoUtils.getEOLBytes();
        Object object = this.updateLock;
        synchronized (object) {
            try (OutputStream outputStream = bl2 ? Files.newOutputStream(path, StandardOpenOption.APPEND) : Files.newOutputStream(path, new OpenOption[0]);){
                if (bl2) {
                    outputStream.write(byArray2);
                }
                outputStream.write(byArray);
                outputStream.write(byArray2);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("updateKnownHostsFile({}) updated: {}", (Object)path, (Object)knownHostEntry);
        }
        this.resetReloadAttributes();
        return knownHostEntry;
    }

    protected KnownHostEntry prepareKnownHostEntry(ClientSession clientSession, SocketAddress socketAddress, PublicKey publicKey) {
        Collection collection = this.resolveHostNetworkIdentities(clientSession, socketAddress);
        if (GenericUtils.isEmpty(collection)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(127);
        Random random = null;
        for (SshdSocketAddress sshdSocketAddress : collection) {
            NamedFactory namedFactory;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            if ((namedFactory = this.getHostValueDigester(clientSession, socketAddress, sshdSocketAddress)) != null) {
                Object object;
                if (random == null) {
                    object = Objects.requireNonNull(clientSession.getFactoryManager(), "No factory manager");
                    Factory factory = Objects.requireNonNull(object.getRandomFactory(), "No random factory");
                    random = Objects.requireNonNull((Random)factory.create(), "No randomizer created");
                }
                object = (Mac)namedFactory.create();
                int n2 = object.getDefaultBlockSize();
                byte[] byArray = new byte[n2];
                random.fill(byArray);
                byte[] byArray2 = KnownHostHashValue.calculateHashValue(sshdSocketAddress.getHostName(), sshdSocketAddress.getPort(), (Mac)object, byArray);
                KnownHostHashValue.append(stringBuilder, namedFactory, byArray, byArray2);
                continue;
            }
            KnownHostHashValue.appendHostPattern(stringBuilder, sshdSocketAddress.getHostName(), sshdSocketAddress.getPort());
        }
        PublicKeyEntry.appendPublicKeyEntry(stringBuilder.append(' '), publicKey);
        return KnownHostEntry.parseKnownHostEntry(stringBuilder.toString());
    }

    protected NamedFactory getHostValueDigester(ClientSession clientSession, SocketAddress socketAddress, SshdSocketAddress sshdSocketAddress) {
        return null;
    }

    protected Collection resolveHostNetworkIdentities(ClientSession clientSession, SocketAddress socketAddress) {
        TreeSet<SshdSocketAddress> treeSet = new TreeSet<SshdSocketAddress>(SshdSocketAddress.BY_HOST_AND_PORT);
        treeSet.add(SshdSocketAddress.toSshdSocketAddress(socketAddress));
        SocketAddress socketAddress2 = clientSession.getConnectAddress();
        treeSet.add(SshdSocketAddress.toSshdSocketAddress(socketAddress2));
        return treeSet;
    }

    @Override
    public boolean acceptModifiedServerKey(ClientSession clientSession, SocketAddress socketAddress, KnownHostEntry knownHostEntry, PublicKey publicKey, PublicKey publicKey2) {
        ModifiedServerKeyAcceptor modifiedServerKeyAcceptor = this.getModifiedServerKeyAcceptor();
        if (modifiedServerKeyAcceptor != null) {
            return modifiedServerKeyAcceptor.acceptModifiedServerKey(clientSession, socketAddress, knownHostEntry, publicKey, publicKey2);
        }
        this.log.warn("acceptModifiedServerKey({}) mismatched keys presented by {} for entry={}: expected={}-{}, actual={}-{}", new Object[]{clientSession, socketAddress, knownHostEntry, KeyUtils.getKeyType(publicKey), KeyUtils.getFingerPrint(publicKey), KeyUtils.getKeyType(publicKey2), KeyUtils.getFingerPrint(publicKey2)});
        return false;
    }
}

