/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.keyverifier;

import java.net.SocketAddress;
import java.security.PublicKey;
import java.util.Map;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class DelegatingServerKeyVerifier
extends AbstractLoggingBean
implements ServerKeyVerifier {
    @Override
    public boolean verifyServerKey(ClientSession clientSession, SocketAddress socketAddress, PublicKey publicKey) {
        Map map = clientSession.getMetadataMap();
        Object v2 = map.get(ServerKeyVerifier.class);
        if (v2 == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("verifyServerKey({}) No verifier found in ClientSession metadata; accepting server key", (Object)socketAddress);
            }
            return true;
        }
        return ((ServerKeyVerifier)v2).verifyServerKey(clientSession, socketAddress, publicKey);
    }
}

