/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.keyverifier;

import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.client.config.hosts.KnownHostEntry;
import org.apache.sshd.client.keyverifier.KnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.io.IoUtils;

public class DefaultKnownHostsServerKeyVerifier
extends KnownHostsServerKeyVerifier {
    private final boolean strict;

    public DefaultKnownHostsServerKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
        this(serverKeyVerifier, true);
    }

    public DefaultKnownHostsServerKeyVerifier(ServerKeyVerifier serverKeyVerifier, boolean bl2) {
        this(serverKeyVerifier, bl2, KnownHostEntry.getDefaultKnownHostsFile(), IoUtils.getLinkOptions(true));
    }

    public DefaultKnownHostsServerKeyVerifier(ServerKeyVerifier serverKeyVerifier, boolean bl2, File file) {
        this(serverKeyVerifier, bl2, Objects.requireNonNull(file, "No file provided").toPath(), IoUtils.getLinkOptions(true));
    }

    public DefaultKnownHostsServerKeyVerifier(ServerKeyVerifier serverKeyVerifier, boolean bl2, Path path, LinkOption ... linkOptionArray) {
        super(serverKeyVerifier, path, linkOptionArray);
        this.strict = bl2;
    }

    public final boolean isStrict() {
        return this.strict;
    }

    @Override
    protected List reloadKnownHosts(ClientSession clientSession, Path path) {
        if (this.isStrict()) {
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry;
            if (this.log.isDebugEnabled()) {
                this.log.debug("reloadKnownHosts({}) check permissions", (Object)path);
            }
            if ((simpleImmutableEntry = DefaultKnownHostsServerKeyVerifier.validateStrictConfigFilePermissions(path, new LinkOption[0])) != null) {
                this.log.warn("reloadKnownHosts({}) invalid file permissions: {}", (Object)path, simpleImmutableEntry.getKey());
                this.updateReloadAttributes();
                return Collections.emptyList();
            }
        }
        return super.reloadKnownHosts(clientSession, path);
    }
}

