/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.kex;

import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Objects;
import org.apache.sshd.client.kex.AbstractDHClientKeyExchange;
import org.apache.sshd.client.kex.DHGEXClient$1;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.core.CoreModuleProperties;

public class DHGEXClient
extends AbstractDHClientKeyExchange {
    protected final DHFactory factory;
    protected byte expected;
    protected int min;
    protected int prf;
    protected int max;
    protected AbstractDH dh;
    protected byte[] g;
    private byte[] p;
    private BigInteger pValue;

    protected DHGEXClient(DHFactory dHFactory, Session session) {
        super(session);
        this.factory = Objects.requireNonNull(dHFactory, "No factory");
        this.min = CoreModuleProperties.PROP_DHGEX_CLIENT_MIN_KEY.get(session).orElse(SecurityUtils.getMinDHGroupExchangeKeySize());
        this.max = CoreModuleProperties.PROP_DHGEX_CLIENT_MAX_KEY.get(session).orElse(SecurityUtils.getMaxDHGroupExchangeKeySize());
        this.prf = CoreModuleProperties.PROP_DHGEX_CLIENT_PRF_KEY.get(session).orElse(Math.min(4096, this.max));
    }

    @Override
    public final String getName() {
        return this.factory.getName();
    }

    protected byte[] getP() {
        return this.p;
    }

    protected BigInteger getPValue() {
        if (this.pValue == null) {
            this.pValue = BufferUtils.fromMPIntBytes(this.getP());
        }
        return this.pValue;
    }

    protected void setP(byte[] byArray) {
        this.p = byArray;
        if (this.pValue != null) {
            this.pValue = null;
        }
    }

    protected void validateEValue() {
        this.validateEValue(this.getPValue());
    }

    protected void validateFValue() {
        this.validateFValue(this.getPValue());
    }

    public static KeyExchangeFactory newFactory(DHFactory dHFactory) {
        return new DHGEXClient$1(dHFactory);
    }

    @Override
    public void init(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        super.init(byArray, byArray2, byArray3, byArray4);
        Session session = this.getSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("init({})[{}] Send SSH_MSG_KEX_DH_GEX_REQUEST - min={}, prf={}, max={}", new Object[]{this, session, this.min, this.prf, this.max});
        }
        if (this.max < this.min || this.prf < this.min || this.max < this.prf) {
            throw new SshException(3, "Protocol error: bad parameters " + this.min + " !< " + this.prf + " !< " + this.max);
        }
        Buffer buffer = session.createBuffer((byte)34, 32);
        buffer.putInt(this.min);
        buffer.putInt(this.prf);
        buffer.putInt(this.max);
        session.writePacket(buffer);
        this.expected = (byte)31;
    }

    @Override
    public boolean next(int n2, Buffer buffer) {
        AbstractClientSession abstractClientSession = this.getClientSession();
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("next({})[{}] process command={} (expected={})", new Object[]{this, abstractClientSession, KeyExchange.getGroupKexOpcodeName(n2), KeyExchange.getGroupKexOpcodeName(this.expected)});
        }
        if (n2 != this.expected) {
            throw new SshException(3, "Protocol error: expected packet " + KeyExchange.getGroupKexOpcodeName(this.expected) + ", got " + KeyExchange.getGroupKexOpcodeName(n2));
        }
        if (n2 == 31) {
            this.setP(buffer.getMPIntAsBytes());
            this.g = buffer.getMPIntAsBytes();
            this.dh = this.getDH(this.getPValue(), new BigInteger(this.g));
            this.hash = this.dh.getHash();
            this.hash.init();
            byte[] byArray = this.updateE(this.dh.getE());
            this.validateEValue();
            if (bl2) {
                this.log.debug("next({})[{}] Send SSH_MSG_KEX_DH_GEX_INIT", (Object)this, (Object)abstractClientSession);
            }
            buffer = abstractClientSession.createBuffer((byte)32, byArray.length + 8);
            buffer.putMPInt(byArray);
            abstractClientSession.writePacket(buffer);
            this.expected = (byte)33;
            return false;
        }
        if (n2 == 33) {
            if (bl2) {
                this.log.debug("next({})[{}] validate SSH_MSG_KEX_DH_GEX_REPLY - min={}, prf={}, max={}", new Object[]{this, abstractClientSession, this.min, this.prf, this.max});
            }
            byte[] byArray = buffer.getBytes();
            byte[] byArray2 = this.updateF(buffer);
            byte[] byArray3 = buffer.getBytes();
            this.validateFValue();
            this.dh.setF(byArray2);
            this.k = this.dh.getK();
            buffer = new ByteArrayBuffer(byArray);
            PublicKey publicKey = buffer.getRawPublicKey();
            String string = abstractClientSession.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS);
            if (GenericUtils.isEmpty(string)) {
                throw new SshException("Unsupported server key type: " + publicKey.getAlgorithm() + " [" + publicKey.getFormat() + "]");
            }
            buffer = new ByteArrayBuffer();
            buffer.putBytes(this.v_c);
            buffer.putBytes(this.v_s);
            buffer.putBytes(this.i_c);
            buffer.putBytes(this.i_s);
            buffer.putBytes(byArray);
            buffer.putInt(this.min);
            buffer.putInt(this.prf);
            buffer.putInt(this.max);
            buffer.putMPInt(this.getP());
            buffer.putMPInt(this.g);
            buffer.putMPInt(this.getE());
            buffer.putMPInt(byArray2);
            buffer.putMPInt(this.k);
            this.hash.update(buffer.array(), 0, buffer.available());
            this.h = this.hash.digest();
            Signature signature = (Signature)ValidateUtils.checkNotNull((Object)((Signature)NamedFactory.create(abstractClientSession.getSignatureFactories(), string)), "No verifier located for algorithm=%s", (Object)string);
            signature.initVerifier(abstractClientSession, publicKey);
            signature.update(abstractClientSession, this.h);
            if (!signature.verify(abstractClientSession, byArray3)) {
                throw new SshException(3, "KeyExchange signature verification failed for key type=" + string);
            }
            abstractClientSession.setServerKey(publicKey);
            return true;
        }
        throw new IllegalStateException("Unknown command value: " + KeyExchange.getGroupKexOpcodeName(n2));
    }

    protected AbstractDH getDH(BigInteger bigInteger, BigInteger bigInteger2) {
        return this.factory.create(bigInteger, bigInteger2);
    }
}

