/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.kex;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Objects;
import org.apache.sshd.client.kex.AbstractDHClientKeyExchange;
import org.apache.sshd.client.kex.DHGClient$1;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.OpenSshCertificate$Type;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.core.CoreModuleProperties;

public class DHGClient
extends AbstractDHClientKeyExchange {
    protected final DHFactory factory;
    protected AbstractDH dh;

    protected DHGClient(DHFactory dHFactory, Session session) {
        super(session);
        this.factory = Objects.requireNonNull(dHFactory, "No factory");
    }

    @Override
    public final String getName() {
        return this.factory.getName();
    }

    public static KeyExchangeFactory newFactory(DHFactory dHFactory) {
        return new DHGClient$1(dHFactory);
    }

    @Override
    public void init(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        super.init(byArray, byArray2, byArray3, byArray4);
        this.dh = this.getDH();
        this.hash = this.dh.getHash();
        this.hash.init();
        byte[] byArray5 = this.updateE(this.dh.getE());
        Session session = this.getSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("init({})[{}] Send SSH_MSG_KEXDH_INIT", (Object)this, (Object)session);
        }
        Buffer buffer = session.createBuffer((byte)30, byArray5.length + 32);
        this.dh.putE(buffer, byArray5);
        session.writePacket(buffer);
    }

    protected AbstractDH getDH() {
        return this.factory.create(new Object[0]);
    }

    @Override
    public boolean next(int n2, Buffer buffer) {
        Object object;
        PublicKey publicKey;
        AbstractClientSession abstractClientSession = this.getClientSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("next({})[{}] process command={}", new Object[]{this, abstractClientSession, KeyExchange.getSimpleKexOpcodeName(n2)});
        }
        if (n2 != 31) {
            throw new SshException(3, "Protocol error: expected packet SSH_MSG_KEXDH_REPLY, got " + KeyExchange.getSimpleKexOpcodeName(n2));
        }
        byte[] byArray = buffer.getBytes();
        byte[] byArray2 = this.updateF(buffer);
        byte[] byArray3 = buffer.getBytes();
        this.dh.setF(byArray2);
        this.k = this.dh.getK();
        buffer = new ByteArrayBuffer(byArray);
        PublicKey publicKey2 = publicKey = buffer.getRawPublicKey();
        if (publicKey instanceof OpenSshCertificate) {
            object = (OpenSshCertificate)publicKey;
            publicKey2 = object.getCertPubKey();
            try {
                this.verifyCertificate(abstractClientSession, (OpenSshCertificate)object);
            }
            catch (SshException sshException) {
                if (((Boolean)CoreModuleProperties.ABORT_ON_INVALID_CERTIFICATE.getRequired(abstractClientSession)).booleanValue()) {
                    throw sshException;
                }
                publicKey = object.getCertPubKey();
                this.log.info("Ignoring invalid certificate {}", (Object)object.getId(), (Object)sshException);
            }
        }
        if (GenericUtils.isEmpty((CharSequence)(object = abstractClientSession.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS)))) {
            throw new SshException("Unsupported server key type: " + publicKey2.getAlgorithm() + "[" + publicKey2.getFormat() + "]");
        }
        buffer = new ByteArrayBuffer();
        buffer.putBytes(this.v_c);
        buffer.putBytes(this.v_s);
        buffer.putBytes(this.i_c);
        buffer.putBytes(this.i_s);
        buffer.putBytes(byArray);
        this.dh.putE(buffer, this.getE());
        this.dh.putF(buffer, byArray2);
        buffer.putMPInt(this.k);
        this.hash.update(buffer.array(), 0, buffer.available());
        this.h = this.hash.digest();
        Signature signature = (Signature)ValidateUtils.checkNotNull((Object)((Signature)NamedFactory.create(abstractClientSession.getSignatureFactories(), (String)object)), "No verifier located for algorithm=%s", object);
        signature.initVerifier(abstractClientSession, publicKey2);
        signature.update(abstractClientSession, this.h);
        if (!signature.verify(abstractClientSession, byArray3)) {
            throw new SshException(3, "KeyExchange signature verification failed for key type=" + (String)object);
        }
        abstractClientSession.setServerKey(publicKey);
        return true;
    }

    protected void verifyCertificate(Session session, OpenSshCertificate openSshCertificate) {
        PublicKey publicKey = openSshCertificate.getCaPubKey();
        String string = KeyUtils.getKeyType(publicKey);
        String string2 = openSshCertificate.getId();
        String string3 = openSshCertificate.getSignatureAlgorithm();
        if (!GenericUtils.isEmpty(string3) && "ssh-rsa".equals(KeyUtils.getCanonicalKeyType(string3))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("verifyCertificate({})[id={}] Allowing to use variant {} instead of {}", new Object[]{session, string2, string3, string});
            }
        } else {
            throw new SshException(3, "Found invalid signature alg " + string3 + " for key ID=" + string2);
        }
        string = string3;
        Signature signature = (Signature)ValidateUtils.checkNotNull((Object)((Signature)NamedFactory.create(session.getSignatureFactories(), string)), "No KeyExchange CA verifier located for algorithm=%s of key ID=%s", string, string2);
        signature.initVerifier(session, publicKey);
        signature.update(session, openSshCertificate.getMessage());
        if (!signature.verify(session, openSshCertificate.getSignature())) {
            throw new SshException(3, "KeyExchange CA signature verification failed for key type=" + string + " of key ID=" + string2);
        }
        if (!OpenSshCertificate$Type.HOST.equals((Object)openSshCertificate.getType())) {
            throw new SshException(3, "KeyExchange signature verification failed, not a host key (2) " + (Object)((Object)openSshCertificate.getType()) + " for key ID=" + string2);
        }
        if (!OpenSshCertificate.isValidNow(openSshCertificate)) {
            throw new SshException(3, "KeyExchange signature verification failed, CA expired for key ID=" + string2);
        }
        SocketAddress socketAddress = this.getClientSession().getConnectAddress();
        if (socketAddress instanceof SshdSocketAddress) {
            socketAddress = ((SshdSocketAddress)socketAddress).toInetSocketAddress();
        }
        if (socketAddress instanceof InetSocketAddress) {
            String string4 = ((InetSocketAddress)socketAddress).getHostString();
            Collection collection = openSshCertificate.getPrincipals();
            if (GenericUtils.isEmpty(collection) || !collection.contains(string4)) {
                throw new SshException(3, "KeyExchange signature verification failed, invalid principal " + string4 + " for key ID=" + string2 + " - allowed=" + collection);
            }
        } else {
            throw new SshException(3, "KeyExchange signature verification failed, could not determine connect host for key ID=" + string2);
        }
        if (!GenericUtils.isEmpty(openSshCertificate.getCriticalOptions())) {
            throw new SshException(3, "KeyExchange signature verification failed, unrecognized critical options " + openSshCertificate.getCriticalOptions() + " for key ID=" + string2);
        }
    }
}

