/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.global;

import java.util.Collection;
import org.apache.sshd.common.channel.RequestHandler$Result;
import org.apache.sshd.common.global.AbstractOpenSshHostKeysHandler;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.keys.BufferPublicKeyParser;

public class OpenSshHostKeysHandler
extends AbstractOpenSshHostKeysHandler {
    public static final String REQUEST = "hostkeys-00@openssh.com";
    public static final OpenSshHostKeysHandler INSTANCE = new OpenSshHostKeysHandler();

    public OpenSshHostKeysHandler() {
        super(REQUEST);
        this.setIgnoreInvalidKeys(true);
    }

    public OpenSshHostKeysHandler(BufferPublicKeyParser bufferPublicKeyParser) {
        super(REQUEST, bufferPublicKeyParser);
        this.setIgnoreInvalidKeys(true);
    }

    @Override
    protected RequestHandler$Result handleHostKeys(Session session, Collection collection, boolean bl2, Buffer buffer) {
        ValidateUtils.checkTrue(!bl2, "Unexpected reply required for the host keys of %s", (Object)session);
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleHostKeys({})[want-reply={}] received {} keys", new Object[]{session, bl2, GenericUtils.size(collection)});
        }
        return RequestHandler$Result.Replied;
    }
}

