/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.future;

import java.util.Objects;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.future.DefaultCancellableSshFuture;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.GenericUtils;

public class DefaultConnectFuture
extends DefaultCancellableSshFuture
implements ConnectFuture {
    public DefaultConnectFuture(Object object, Object object2) {
        super(object, object2);
    }

    @Override
    public ConnectFuture verify(long l2, CancelOption ... cancelOptionArray) {
        CancelOption[] cancelOptionArray2 = cancelOptionArray;
        if (GenericUtils.isEmpty((Object[])cancelOptionArray2)) {
            cancelOptionArray2 = new CancelOption[]{CancelOption.CANCEL_ON_TIMEOUT, CancelOption.CANCEL_ON_INTERRUPT};
        }
        long l3 = System.nanoTime();
        ClientSession clientSession = (ClientSession)this.verifyResult(ClientSession.class, l2, cancelOptionArray2);
        long l4 = System.nanoTime();
        if (this.log.isDebugEnabled()) {
            IoSession ioSession = clientSession.getIoSession();
            this.log.debug("Connected to {} after {} nanos", (Object)ioSession.getRemoteAddress(), (Object)(l4 - l3));
        }
        return this;
    }

    @Override
    public ClientSession getSession() {
        Object object = this.getValue();
        if (object instanceof RuntimeException) {
            throw (RuntimeException)object;
        }
        if (object instanceof Error) {
            throw (Error)object;
        }
        if (object instanceof Throwable) {
            throw new RuntimeSshException("Failed to get the session.", (Throwable)object);
        }
        if (object instanceof ClientSession) {
            return (ClientSession)object;
        }
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.getValue() instanceof ClientSession;
    }

    @Override
    public void setSession(ClientSession clientSession) {
        Objects.requireNonNull(clientSession, "No client session provided");
        this.setValue(clientSession);
    }
}

