/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.future;

import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.future.DefaultCancellableSshFuture;

public class DefaultAuthFuture
extends DefaultCancellableSshFuture
implements AuthFuture {
    private final CancelFuture cancellation;
    private AtomicBoolean cancellable = new AtomicBoolean(true);

    public DefaultAuthFuture(Object object, Object object2) {
        super(object, object2);
        this.cancellation = this.createCancellation();
        this.addListener(authFuture -> {
            Object object;
            if (this.isDone() && !((object = this.getValue()) instanceof CancelFuture)) {
                this.cancellation.setNotCanceled();
            }
        });
    }

    @Override
    public AuthFuture verify(long l2, CancelOption ... cancelOptionArray) {
        Boolean bl2 = (Boolean)this.verifyResult(Boolean.class, l2, cancelOptionArray);
        if (!bl2.booleanValue()) {
            throw (SshException)this.formatExceptionMessage(SshException::new, "Authentication failed while waiting %d msec.", l2);
        }
        return this;
    }

    @Override
    public boolean isSuccess() {
        Object object = this.getValue();
        return object instanceof Boolean && (Boolean)object != false;
    }

    @Override
    public boolean isFailure() {
        Object object = this.getValue();
        if (object instanceof Boolean) {
            return (Boolean)object == false;
        }
        return true;
    }

    @Override
    public void setAuthed(boolean bl2) {
        this.setValue(bl2);
    }

    @Override
    public CancelFuture cancel() {
        this.cancellation.setBackTrace(new CancellationException("Programmatically canceled"));
        if (this.cancellable.get()) {
            this.setValue(this.cancellation);
        }
        return this.cancellation;
    }

    @Override
    public CancelFuture getCancellation() {
        return this.wasCanceled() ? this.cancellation : null;
    }

    @Override
    public boolean wasCanceled() {
        return this.cancellation.getBackTrace() != null;
    }

    @Override
    public void setCancellable(boolean bl2) {
        this.cancellable.set(bl2);
        if (this.wasCanceled() && this.cancellable.get()) {
            this.setValue(this.cancellation);
        }
    }
}

