/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.config.keys.ClientIdentityLoaderHolder;
import org.apache.sshd.client.config.keys.LazyClientKeyIdentityProvider$1;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.FilePasswordProviderHolder;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;

public class LazyClientKeyIdentityProvider
implements ClientIdentityLoaderHolder,
FilePasswordProviderHolder,
KeyIdentityProvider {
    private final ClientIdentityLoader clientIdentityLoader;
    private final Collection locations;
    private final FilePasswordProvider passwordProvider;
    private final boolean ignoreNonExisting;

    public LazyClientKeyIdentityProvider(ClientIdentityLoader clientIdentityLoader, Collection collection, FilePasswordProvider filePasswordProvider, boolean bl2) {
        this.clientIdentityLoader = Objects.requireNonNull(clientIdentityLoader, "No client identity loader provided");
        this.locations = collection;
        this.passwordProvider = filePasswordProvider;
        this.ignoreNonExisting = bl2;
    }

    @Override
    public ClientIdentityLoader getClientIdentityLoader() {
        return this.clientIdentityLoader;
    }

    public Collection getLocations() {
        return this.locations;
    }

    @Override
    public FilePasswordProvider getFilePasswordProvider() {
        return this.passwordProvider;
    }

    public boolean isIgnoreNonExisting() {
        return this.ignoreNonExisting;
    }

    @Override
    public Iterable loadKeys(SessionContext sessionContext) {
        Collection collection = this.getLocations();
        if (GenericUtils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        return () -> new LazyClientKeyIdentityProvider$1(this, collection, sessionContext);
    }

    protected Iterable loadClientIdentities(SessionContext sessionContext, NamedResource namedResource) {
        ClientIdentityLoader clientIdentityLoader = this.getClientIdentityLoader();
        boolean bl2 = this.isIgnoreNonExisting();
        try {
            if (!clientIdentityLoader.isValidLocation(namedResource)) {
                if (bl2) {
                    return null;
                }
                throw new FileNotFoundException("Invalid identity location: " + namedResource.getName());
            }
        }
        catch (IOException iOException) {
            if (bl2) {
                return null;
            }
            throw iOException;
        }
        return clientIdentityLoader.loadClientIdentities(sessionContext, namedResource, this.getFilePasswordProvider());
    }
}

