/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sshd.client.config.keys.LazyClientKeyIdentityProvider;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.SessionContext;

class LazyClientKeyIdentityProvider$1
implements Iterator {
    private KeyPair currentPair;
    private boolean finished;
    private final Iterator iter;
    private Iterator currentIdentities;
    final /* synthetic */ Collection val$locs;
    final /* synthetic */ SessionContext val$session;
    final /* synthetic */ LazyClientKeyIdentityProvider this$0;

    LazyClientKeyIdentityProvider$1(LazyClientKeyIdentityProvider lazyClientKeyIdentityProvider, Collection collection, SessionContext sessionContext) {
        this.this$0 = lazyClientKeyIdentityProvider;
        this.val$locs = collection;
        this.val$session = sessionContext;
        this.iter = this.val$locs.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        this.currentPair = KeyIdentityProvider.exhaustCurrentIdentities(this.currentIdentities);
        if (this.currentPair != null) {
            return true;
        }
        while (this.iter.hasNext()) {
            Iterable iterable;
            NamedResource namedResource = (NamedResource)this.iter.next();
            try {
                iterable = this.this$0.loadClientIdentities(this.val$session, namedResource);
            }
            catch (IOException | GeneralSecurityException exception) {
                throw new IllegalStateException("Failed (" + exception.getClass().getSimpleName() + ") to load key from " + namedResource.getName() + ": " + exception.getMessage(), exception);
            }
            this.currentIdentities = iterable == null ? null : iterable.iterator();
            this.currentPair = KeyIdentityProvider.exhaustCurrentIdentities(this.currentIdentities);
            if (this.currentPair == null) continue;
            return true;
        }
        this.finished = true;
        return false;
    }

    public KeyPair next() {
        if (this.finished) {
            throw new NoSuchElementException("All identities have been exhausted");
        }
        if (this.currentPair == null) {
            throw new IllegalStateException("'next()' called without asking 'hasNext()'");
        }
        KeyPair keyPair = this.currentPair;
        this.currentPair = null;
        return keyPair;
    }

    public String toString() {
        return Iterator.class.getSimpleName() + "[" + LazyClientKeyIdentityProvider.class.getSimpleName() + "]";
    }
}

