/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.security.KeyPair;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.sshd.client.config.keys.ClientIdentityProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;

public class LazyClientIdentityIterator
implements Iterator {
    protected boolean finished;
    protected Iterator currentIdentities;
    protected KeyPair currentPair;
    private final Iterator providers;
    private final Function kpExtractor;
    private final Predicate filter;

    public LazyClientIdentityIterator(Iterator iterator, Function function, Predicate predicate) {
        this.providers = iterator;
        this.kpExtractor = Objects.requireNonNull(function, "No key pair extractor provided");
        this.filter = predicate;
    }

    public Iterator getProviders() {
        return this.providers;
    }

    public Function getIdentitiesExtractor() {
        return this.kpExtractor;
    }

    public Predicate getFilter() {
        return this.filter;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        Iterator iterator = this.getProviders();
        if (iterator == null) {
            this.finished = true;
            return false;
        }
        this.currentPair = KeyIdentityProvider.exhaustCurrentIdentities(this.currentIdentities);
        if (this.currentPair != null) {
            return true;
        }
        Function function = this.getIdentitiesExtractor();
        Predicate predicate = this.getFilter();
        while (iterator.hasNext()) {
            ClientIdentityProvider clientIdentityProvider = (ClientIdentityProvider)iterator.next();
            if (clientIdentityProvider == null) continue;
            Iterable iterable = (Iterable)function.apply(clientIdentityProvider);
            this.currentIdentities = iterable == null ? null : iterable.iterator();
            this.currentPair = KeyIdentityProvider.exhaustCurrentIdentities(this.currentIdentities);
            if (this.currentPair == null || predicate != null && !predicate.test(this.currentPair)) continue;
            return true;
        }
        this.finished = true;
        return false;
    }

    public KeyPair next() {
        if (this.finished) {
            throw new NoSuchElementException("All identities have been exhausted");
        }
        if (this.currentPair == null) {
            throw new IllegalStateException("'next()' called without asking 'hasNext()'");
        }
        KeyPair keyPair = this.currentPair;
        this.currentPair = null;
        return keyPair;
    }

    public String toString() {
        return ClientIdentityProvider.class.getSimpleName() + "[lazy-iterator]";
    }
}

