/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.security.KeyPair;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.sshd.client.config.keys.ClientIdentityProvider$1;
import org.apache.sshd.client.config.keys.LazyClientIdentityIterator;
import org.apache.sshd.common.session.SessionContext;

@FunctionalInterface
public interface ClientIdentityProvider {
    public Iterable getClientIdentities(SessionContext var1);

    public static ClientIdentityProvider of(KeyPair keyPair) {
        return sessionContext -> Collections.singletonList(keyPair);
    }

    public static Iterable lazyKeysLoader(Iterable iterable, Function function, Predicate predicate) {
        Objects.requireNonNull(function, "No key pair extractor provided");
        if (iterable == null) {
            return Collections.emptyList();
        }
        return new ClientIdentityProvider$1(iterable, function, predicate);
    }

    public static Iterator lazyKeysIterator(Iterator iterator, Function function, Predicate predicate) {
        Objects.requireNonNull(function, "No key pair extractor provided");
        return iterator == null ? Collections.emptyIterator() : new LazyClientIdentityIterator(iterator, function, predicate);
    }
}

