/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.security.SecurityUtils;

final class ClientIdentityLoader$1
implements ClientIdentityLoader {
    ClientIdentityLoader$1() {
    }

    @Override
    public boolean isValidLocation(NamedResource namedResource) {
        Path path = this.toPath(namedResource);
        return Files.exists(path, IoUtils.EMPTY_LINK_OPTIONS);
    }

    @Override
    public Iterable loadClientIdentities(SessionContext sessionContext, NamedResource namedResource, FilePasswordProvider filePasswordProvider) {
        Path path = this.toPath(namedResource);
        PathResource pathResource = new PathResource(path);
        try (InputStream inputStream = pathResource.openInputStream();){
            Iterable iterable = SecurityUtils.loadKeyPairIdentities(sessionContext, pathResource, inputStream, filePasswordProvider);
            return iterable;
        }
    }

    public String toString() {
        return "DEFAULT";
    }

    private Path toPath(NamedResource namedResource) {
        Objects.requireNonNull(namedResource, "No location provided");
        Path path = Paths.get(ValidateUtils.checkNotNullAndNotEmpty(namedResource.getName(), "No location value for %s", (Object)namedResource), new String[0]);
        path = path.toAbsolutePath();
        path = path.normalize();
        return path;
    }
}

