/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.nio.file.Path;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.config.keys.ClientIdentityLoaderHolder;
import org.apache.sshd.client.config.keys.ClientIdentityProvider;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.FilePasswordProviderHolder;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.apache.sshd.common.util.io.resource.PathResource;

public class ClientIdentityFileWatcher
extends ModifiableFileWatcher
implements ClientIdentityLoaderHolder,
ClientIdentityProvider,
FilePasswordProviderHolder {
    private final AtomicReference identitiesHolder = new AtomicReference<Object>(null);
    private final ClientIdentityLoaderHolder loaderHolder;
    private final FilePasswordProviderHolder providerHolder;
    private final boolean strict;

    public ClientIdentityFileWatcher(Path path, ClientIdentityLoader clientIdentityLoader, FilePasswordProvider filePasswordProvider) {
        this(path, clientIdentityLoader, filePasswordProvider, true);
    }

    public ClientIdentityFileWatcher(Path path, ClientIdentityLoader clientIdentityLoader, FilePasswordProvider filePasswordProvider, boolean bl2) {
        this(path, ClientIdentityLoaderHolder.loaderHolderOf(Objects.requireNonNull(clientIdentityLoader, "No client identity loader")), FilePasswordProviderHolder.providerHolderOf(Objects.requireNonNull(filePasswordProvider, "No password provider")), bl2);
    }

    public ClientIdentityFileWatcher(Path path, ClientIdentityLoaderHolder clientIdentityLoaderHolder, FilePasswordProviderHolder filePasswordProviderHolder) {
        this(path, clientIdentityLoaderHolder, filePasswordProviderHolder, true);
    }

    public ClientIdentityFileWatcher(Path path, ClientIdentityLoaderHolder clientIdentityLoaderHolder, FilePasswordProviderHolder filePasswordProviderHolder, boolean bl2) {
        super(path);
        this.loaderHolder = Objects.requireNonNull(clientIdentityLoaderHolder, "No client identity loader");
        this.providerHolder = Objects.requireNonNull(filePasswordProviderHolder, "No password provider");
        this.strict = bl2;
    }

    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public ClientIdentityLoader getClientIdentityLoader() {
        return this.loaderHolder.getClientIdentityLoader();
    }

    @Override
    public FilePasswordProvider getFilePasswordProvider() {
        return this.providerHolder.getFilePasswordProvider();
    }

    @Override
    public Iterable getClientIdentities(SessionContext sessionContext) {
        if (!this.checkReloadRequired()) {
            return (Iterable)this.identitiesHolder.get();
        }
        this.identitiesHolder.set(null);
        Path path = this.getPath();
        if (!this.exists()) {
            return (Iterable)this.identitiesHolder.get();
        }
        Iterable iterable = this.reloadClientIdentities(sessionContext, path);
        this.updateReloadAttributes();
        this.identitiesHolder.set(iterable);
        return iterable;
    }

    protected Iterable reloadClientIdentities(SessionContext sessionContext, Path path) {
        Object object;
        if (this.isStrict() && (object = KeyUtils.validateStrictKeyFilePermissions(path, IoUtils.EMPTY_LINK_OPTIONS)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("reloadClientIdentity({}) ignore due to {}", (Object)path, object.getKey());
            }
            return null;
        }
        object = new PathResource(path);
        ClientIdentityLoader clientIdentityLoader = Objects.requireNonNull(this.getClientIdentityLoader(), "No client identity loader");
        if (clientIdentityLoader.isValidLocation((NamedResource)object)) {
            Iterable iterable = clientIdentityLoader.loadClientIdentities(sessionContext, (NamedResource)object, this.getFilePasswordProvider());
            if (this.log.isTraceEnabled()) {
                if (iterable == null) {
                    this.log.trace("reloadClientIdentity({}) no keys loaded", object);
                } else {
                    for (KeyPair keyPair : iterable) {
                        PublicKey publicKey = keyPair == null ? null : keyPair.getPublic();
                        if (publicKey == null) continue;
                        this.log.trace("reloadClientIdentity({}) loaded {}-{}", new Object[]{object, KeyUtils.getKeyType(publicKey), KeyUtils.getFingerPrint(publicKey)});
                    }
                }
            }
            return iterable;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("reloadClientIdentity({}) invalid location", object);
        }
        return null;
    }
}

