/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.BuiltinIdentities;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.IdentityUtils;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.FileInfoExtractor;
import org.apache.sshd.common.util.io.IoUtils;

public final class ClientIdentity {
    public static final String ID_FILE_PREFIX = "id_";
    public static final String ID_FILE_SUFFIX = "";
    public static final Function ID_GENERATOR = ClientIdentity::getIdentityFileName;

    private ClientIdentity() {
        throw new UnsupportedOperationException("No instance");
    }

    public static String getIdentityType(String string) {
        if (GenericUtils.isEmpty(string) || string.length() <= ID_FILE_PREFIX.length() || !string.startsWith(ID_FILE_PREFIX)) {
            return null;
        }
        return string.substring(ID_FILE_PREFIX.length());
    }

    public static String getIdentityFileName(NamedResource namedResource) {
        return ClientIdentity.getIdentityFileName(namedResource == null ? null : namedResource.getName());
    }

    public static String getIdentityFileName(String string) {
        return IdentityUtils.getIdentityFileName(ID_FILE_PREFIX, string, ID_FILE_SUFFIX);
    }

    public static KeyPairProvider loadDefaultKeyPairProvider(boolean bl2, boolean bl3, FilePasswordProvider filePasswordProvider, LinkOption ... linkOptionArray) {
        return ClientIdentity.loadDefaultKeyPairProvider(PublicKeyEntry.getDefaultKeysFolderPath(), bl2, bl3, filePasswordProvider, linkOptionArray);
    }

    public static KeyPairProvider loadDefaultKeyPairProvider(Path path, boolean bl2, boolean bl3, FilePasswordProvider filePasswordProvider, LinkOption ... linkOptionArray) {
        Map map = ClientIdentity.loadDefaultIdentities(path, bl2, filePasswordProvider, linkOptionArray);
        return IdentityUtils.createKeyPairProvider(map, bl3);
    }

    public static Map loadDefaultIdentities(boolean bl2, FilePasswordProvider filePasswordProvider, LinkOption ... linkOptionArray) {
        return ClientIdentity.loadDefaultIdentities(PublicKeyEntry.getDefaultKeysFolderPath(), bl2, filePasswordProvider, linkOptionArray);
    }

    public static Map loadDefaultIdentities(Path path, boolean bl2, FilePasswordProvider filePasswordProvider, LinkOption ... linkOptionArray) {
        return ClientIdentity.loadIdentities(null, path, bl2, BuiltinIdentities.NAMES, ID_GENERATOR, filePasswordProvider, linkOptionArray);
    }

    public static Map loadIdentities(SessionContext sessionContext, Path path, boolean bl2, Collection collection, Function function, FilePasswordProvider filePasswordProvider, LinkOption ... linkOptionArray) {
        Map map = ClientIdentity.scanIdentitiesFolder(path, bl2, collection, function, linkOptionArray);
        return IdentityUtils.loadIdentities(sessionContext, map, filePasswordProvider, IoUtils.EMPTY_OPEN_OPTIONS);
    }

    public static Map scanIdentitiesFolder(Path path, boolean bl2, Collection collection, Function function, LinkOption ... linkOptionArray) {
        if (GenericUtils.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        if (!Files.exists(path, linkOptionArray)) {
            return Collections.emptyMap();
        }
        ValidateUtils.checkTrue((boolean)((Boolean)FileInfoExtractor.ISDIR.infoOf(path, linkOptionArray)), "Not a directory: %s", (Object)path);
        TreeMap<String, Path> treeMap = new TreeMap<String, Path>(String.CASE_INSENSITIVE_ORDER);
        for (String string : collection) {
            String string2 = (String)function.apply(string);
            Path path2 = path.resolve(string2);
            if (!Files.exists(path2, linkOptionArray) || bl2 && KeyUtils.validateStrictKeyFilePermissions(path2, linkOptionArray) != null) continue;
            Path path3 = treeMap.put(string, path2);
            ValidateUtils.checkTrue(path3 == null, "Multiple mappings for type=%s", (Object)string);
        }
        return treeMap;
    }
}

