/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.sshd.client.config.keys.ClientIdentityFileWatcher;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.config.keys.ClientIdentityLoaderHolder;
import org.apache.sshd.client.config.keys.ClientIdentityProvider;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.FilePasswordProviderHolder;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;

public class ClientIdentitiesWatcher
extends AbstractKeyPairProvider {
    private final Collection providers;

    public ClientIdentitiesWatcher(Collection collection, ClientIdentityLoader clientIdentityLoader, FilePasswordProvider filePasswordProvider) {
        this(collection, clientIdentityLoader, filePasswordProvider, true);
    }

    public ClientIdentitiesWatcher(Collection collection, ClientIdentityLoader clientIdentityLoader, FilePasswordProvider filePasswordProvider, boolean bl2) {
        this(collection, ClientIdentityLoaderHolder.loaderHolderOf(Objects.requireNonNull(clientIdentityLoader, "No client identity loader")), FilePasswordProviderHolder.providerHolderOf(Objects.requireNonNull(filePasswordProvider, "No password provider")), bl2);
    }

    public ClientIdentitiesWatcher(Collection collection, ClientIdentityLoaderHolder clientIdentityLoaderHolder, FilePasswordProviderHolder filePasswordProviderHolder) {
        this(collection, clientIdentityLoaderHolder, filePasswordProviderHolder, true);
    }

    public ClientIdentitiesWatcher(Collection collection, ClientIdentityLoaderHolder clientIdentityLoaderHolder, FilePasswordProviderHolder filePasswordProviderHolder, boolean bl2) {
        this(ClientIdentitiesWatcher.buildProviders(collection, clientIdentityLoaderHolder, filePasswordProviderHolder, bl2));
    }

    public ClientIdentitiesWatcher(Collection collection) {
        this.providers = collection;
    }

    @Override
    public Iterable loadKeys(SessionContext sessionContext) {
        return this.loadKeys(sessionContext, null);
    }

    protected Iterable loadKeys(SessionContext sessionContext, Predicate predicate) {
        return ClientIdentityProvider.lazyKeysLoader(this.providers, clientIdentityProvider -> this.doGetKeyPairs(sessionContext, (ClientIdentityProvider)clientIdentityProvider), predicate);
    }

    protected Iterable doGetKeyPairs(SessionContext sessionContext, ClientIdentityProvider clientIdentityProvider) {
        try {
            Iterable iterable = clientIdentityProvider.getClientIdentities(sessionContext);
            if (iterable == null && this.log.isDebugEnabled()) {
                this.log.debug("loadKeys({}) no key loaded", (Object)clientIdentityProvider);
            }
            return iterable;
        }
        catch (Throwable throwable) {
            this.warn("loadKeys({}) failed ({}) to load key: {}", clientIdentityProvider, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
            return null;
        }
    }

    public static List buildProviders(Collection collection, ClientIdentityLoader clientIdentityLoader, FilePasswordProvider filePasswordProvider, boolean bl2) {
        return ClientIdentitiesWatcher.buildProviders(collection, ClientIdentityLoaderHolder.loaderHolderOf(Objects.requireNonNull(clientIdentityLoader, "No client identity loader")), FilePasswordProviderHolder.providerHolderOf(Objects.requireNonNull(filePasswordProvider, "No password provider")), bl2);
    }

    public static List buildProviders(Collection collection, ClientIdentityLoaderHolder clientIdentityLoaderHolder, FilePasswordProviderHolder filePasswordProviderHolder, boolean bl2) {
        if (GenericUtils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        return GenericUtils.map(collection, path -> new ClientIdentityFileWatcher((Path)path, clientIdentityLoaderHolder, filePasswordProviderHolder, bl2));
    }
}

