/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.nio.file.Path;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.client.config.keys.ClientIdentitiesWatcher;
import org.apache.sshd.client.config.keys.ClientIdentity;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.config.keys.ClientIdentityLoaderHolder;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.BuiltinIdentities;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.FilePasswordProviderHolder;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;

public class BuiltinClientIdentitiesWatcher
extends ClientIdentitiesWatcher {
    private final boolean supportedOnly;

    public BuiltinClientIdentitiesWatcher(Path path, boolean bl2, ClientIdentityLoader clientIdentityLoader, FilePasswordProvider filePasswordProvider, boolean bl3) {
        this(path, (Collection)NamedResource.getNameList(BuiltinIdentities.VALUES), bl2, clientIdentityLoader, filePasswordProvider, bl3);
    }

    public BuiltinClientIdentitiesWatcher(Path path, Collection collection, boolean bl2, ClientIdentityLoader clientIdentityLoader, FilePasswordProvider filePasswordProvider, boolean bl3) {
        this(path, collection, bl2, ClientIdentityLoaderHolder.loaderHolderOf(Objects.requireNonNull(clientIdentityLoader, "No client identity loader")), FilePasswordProviderHolder.providerHolderOf(Objects.requireNonNull(filePasswordProvider, "No password provider")), bl3);
    }

    public BuiltinClientIdentitiesWatcher(Path path, boolean bl2, ClientIdentityLoaderHolder clientIdentityLoaderHolder, FilePasswordProviderHolder filePasswordProviderHolder, boolean bl3) {
        this(path, (Collection)NamedResource.getNameList(BuiltinIdentities.VALUES), bl2, clientIdentityLoaderHolder, filePasswordProviderHolder, bl3);
    }

    public BuiltinClientIdentitiesWatcher(Path path, Collection collection, boolean bl2, ClientIdentityLoaderHolder clientIdentityLoaderHolder, FilePasswordProviderHolder filePasswordProviderHolder, boolean bl3) {
        super((Collection)BuiltinClientIdentitiesWatcher.getBuiltinIdentitiesPaths(path, collection), clientIdentityLoaderHolder, filePasswordProviderHolder, bl3);
        this.supportedOnly = bl2;
    }

    public final boolean isSupportedOnly() {
        return this.supportedOnly;
    }

    @Override
    public Iterable loadKeys(SessionContext sessionContext) {
        return this.isSupportedOnly() ? this.loadKeys(sessionContext, keyPair -> this.isSupported(sessionContext, (KeyPair)keyPair)) : super.loadKeys(sessionContext);
    }

    protected boolean isSupported(SessionContext sessionContext, KeyPair keyPair) {
        BuiltinIdentities builtinIdentities = BuiltinIdentities.fromKeyPair(keyPair);
        if (builtinIdentities != null && builtinIdentities.isSupported()) {
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("loadKeys - remove unsupported identity={}, key-type={}, key={}", new Object[]{builtinIdentities, KeyUtils.getKeyType(keyPair), KeyUtils.getFingerPrint(keyPair.getPublic())});
        }
        return false;
    }

    public static List getDefaultBuiltinIdentitiesPaths(Path path) {
        return BuiltinClientIdentitiesWatcher.getBuiltinIdentitiesPaths(path, NamedResource.getNameList(BuiltinIdentities.VALUES));
    }

    public static List getBuiltinIdentitiesPaths(Path path, Collection collection) {
        Objects.requireNonNull(path, "No keys folder");
        if (GenericUtils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        ArrayList<Path> arrayList = new ArrayList<Path>(collection.size());
        for (String string : collection) {
            String string2 = ClientIdentity.getIdentityFileName(string);
            arrayList.add(path.resolve(string2));
        }
        return arrayList;
    }
}

