/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.apache.sshd.client.config.hosts.KnownHostDigest;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class KnownHostHashValue {
    public static final char HASHED_HOST_DELIMITER = '|';
    public static final NamedFactory DEFAULT_DIGEST = KnownHostDigest.SHA1;
    private NamedFactory digester = DEFAULT_DIGEST;
    private byte[] saltValue;
    private byte[] digestValue;

    public NamedFactory getDigester() {
        return this.digester;
    }

    public void setDigester(NamedFactory namedFactory) {
        this.digester = namedFactory;
    }

    public byte[] getSaltValue() {
        return this.saltValue;
    }

    public void setSaltValue(byte[] byArray) {
        this.saltValue = byArray;
    }

    public byte[] getDigestValue() {
        return this.digestValue;
    }

    public void setDigestValue(byte[] byArray) {
        this.digestValue = byArray;
    }

    public boolean isHostMatch(String string, int n2) {
        if (GenericUtils.isEmpty(string)) {
            return false;
        }
        try {
            byte[] byArray = this.getDigestValue();
            byte[] byArray2 = KnownHostHashValue.calculateHashValue(string, n2, this.getDigester(), this.getSaltValue());
            return Arrays.equals(byArray, byArray2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeSshException("Failed (" + throwable.getClass().getSimpleName() + ") to calculate hash value: " + throwable.getMessage(), throwable);
        }
    }

    public String toString() {
        if (this.getDigester() == null || NumberUtils.isEmpty(this.getSaltValue()) || NumberUtils.isEmpty(this.getDigestValue())) {
            return Objects.toString(this.getDigester(), null) + "-" + BufferUtils.toHex(':', this.getSaltValue()) + "-" + BufferUtils.toHex(':', this.getDigestValue());
        }
        try {
            return ((StringBuilder)KnownHostHashValue.append(new StringBuilder(127), this)).toString();
        }
        catch (IOException | RuntimeException exception) {
            return exception.getClass().getSimpleName() + ": " + exception.getMessage();
        }
    }

    public static byte[] calculateHashValue(String string, int n2, Factory factory, byte[] byArray) {
        return KnownHostHashValue.calculateHashValue(string, n2, (Mac)factory.create(), byArray);
    }

    public static byte[] calculateHashValue(String string, int n2, Mac mac, byte[] byArray) {
        mac.init(byArray);
        String string2 = KnownHostHashValue.createHostPattern(string, n2);
        byte[] byArray2 = string2.getBytes(StandardCharsets.UTF_8);
        mac.update(byArray2);
        return mac.doFinal();
    }

    public static String createHostPattern(String string, int n2) {
        if (SshConstants.TO_EFFECTIVE_PORT.applyAsInt(n2) == 22) {
            return string;
        }
        try {
            return ((StringBuilder)KnownHostHashValue.appendHostPattern(new StringBuilder(string.length() + 8), string, n2)).toString();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Unexpected (" + iOException.getClass().getSimpleName() + ") failure to generate host pattern of " + string + ":" + n2 + ": " + iOException.getMessage(), iOException);
        }
    }

    public static Appendable appendHostPattern(Appendable appendable, String string, int n2) {
        boolean bl2;
        boolean bl3 = bl2 = SshConstants.TO_EFFECTIVE_PORT.applyAsInt(n2) != 22;
        if (bl2) {
            appendable.append('[');
        }
        appendable.append(string);
        if (bl2) {
            appendable.append(']');
            appendable.append(':');
            appendable.append(Integer.toString(n2));
        }
        return appendable;
    }

    public static Appendable append(Appendable appendable, KnownHostHashValue knownHostHashValue) {
        return knownHostHashValue == null ? appendable : KnownHostHashValue.append(appendable, knownHostHashValue.getDigester(), knownHostHashValue.getSaltValue(), knownHostHashValue.getDigestValue());
    }

    public static Appendable append(Appendable appendable, NamedResource namedResource, byte[] byArray, byte[] byArray2) {
        Base64.Encoder encoder = Base64.getEncoder();
        appendable.append('|').append(namedResource.getName());
        appendable.append('|').append(encoder.encodeToString(byArray));
        appendable.append('|').append(encoder.encodeToString(byArray2));
        return appendable;
    }

    public static KnownHostHashValue parse(String string) {
        String string2;
        return KnownHostHashValue.parse(string2, GenericUtils.isEmpty(string2 = GenericUtils.replaceWhitespaceAndTrim(string)) ? null : new KnownHostHashValue());
    }

    public static KnownHostHashValue parse(String string, KnownHostHashValue knownHostHashValue) {
        String string2 = GenericUtils.replaceWhitespaceAndTrim(string);
        if (GenericUtils.isEmpty(string2)) {
            return knownHostHashValue;
        }
        String[] stringArray = GenericUtils.split(string2, '|');
        ValidateUtils.checkTrue(stringArray.length == 4, "Invalid hash pattern (insufficient data): %s", (Object)string2);
        ValidateUtils.checkTrue(GenericUtils.isEmpty(stringArray[0]), "Invalid hash pattern (unexpected extra data): %s", (Object)string2);
        NamedFactory namedFactory = (NamedFactory)ValidateUtils.checkNotNull((Object)KnownHostDigest.fromName(stringArray[1]), "Invalid hash pattern (unknown digest): %s", (Object)string2);
        Base64.Decoder decoder = Base64.getDecoder();
        knownHostHashValue.setDigester(namedFactory);
        knownHostHashValue.setSaltValue(decoder.decode(stringArray[2]));
        knownHostHashValue.setDigestValue(decoder.decode(stringArray[3]));
        return knownHostHashValue;
    }
}

