/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.client.config.hosts.HostPatternsHolder;
import org.apache.sshd.client.config.hosts.KnownHostEntry$LazyDefaultConfigFileHolder;
import org.apache.sshd.client.config.hosts.KnownHostHashValue;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.input.NoCloseInputStream;
import org.apache.sshd.common.util.io.input.NoCloseReader;

public class KnownHostEntry
extends HostPatternsHolder {
    public static final char MARKER_INDICATOR = '@';
    public static final String STD_HOSTS_FILENAME = "known_hosts";
    private String line;
    private String marker;
    private AuthorizedKeyEntry keyEntry;
    private KnownHostHashValue hashedEntry;

    public KnownHostEntry() {
    }

    public KnownHostEntry(String string) {
        this.line = string;
    }

    public String getConfigLine() {
        return this.line;
    }

    public void setConfigLine(String string) {
        this.line = string;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String string) {
        this.marker = string;
    }

    public AuthorizedKeyEntry getKeyEntry() {
        return this.keyEntry;
    }

    public void setKeyEntry(AuthorizedKeyEntry authorizedKeyEntry) {
        this.keyEntry = authorizedKeyEntry;
    }

    public KnownHostHashValue getHashedEntry() {
        return this.hashedEntry;
    }

    public void setHashedEntry(KnownHostHashValue knownHostHashValue) {
        this.hashedEntry = knownHostHashValue;
    }

    @Override
    public boolean isHostMatch(String string, int n2) {
        if (super.isHostMatch(string, n2)) {
            return true;
        }
        KnownHostHashValue knownHostHashValue = this.getHashedEntry();
        return knownHostHashValue != null && knownHostHashValue.isHostMatch(string, n2);
    }

    public String toString() {
        return this.getConfigLine();
    }

    public static Path getDefaultKnownHostsFile() {
        return KnownHostEntry$LazyDefaultConfigFileHolder.access$000();
    }

    public static List readKnownHostEntries(Path path, OpenOption ... openOptionArray) {
        try (InputStream inputStream = Files.newInputStream(path, openOptionArray);){
            List list = KnownHostEntry.readKnownHostEntries(inputStream, true);
            return list;
        }
    }

    public static List readKnownHostEntries(URL uRL) {
        try (InputStream inputStream = uRL.openStream();){
            List list = KnownHostEntry.readKnownHostEntries(inputStream, true);
            return list;
        }
    }

    public static List readKnownHostEntries(InputStream inputStream, boolean bl2) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(NoCloseInputStream.resolveInputStream(inputStream, bl2), StandardCharsets.UTF_8);){
            List list = KnownHostEntry.readKnownHostEntries(inputStreamReader, true);
            return list;
        }
    }

    public static List readKnownHostEntries(Reader reader, boolean bl2) {
        try (BufferedReader bufferedReader = new BufferedReader(NoCloseReader.resolveReader(reader, bl2));){
            List list = KnownHostEntry.readKnownHostEntries(bufferedReader);
            return list;
        }
    }

    public static List readKnownHostEntries(BufferedReader bufferedReader) {
        ArrayList<KnownHostEntry> arrayList = null;
        int n2 = 1;
        String string = bufferedReader.readLine();
        while (string != null) {
            int n3;
            if (!GenericUtils.isEmpty(string = GenericUtils.trimToEmpty(string)) && (n3 = string.indexOf(35)) != 0) {
                if (n3 > 0) {
                    string = string.substring(0, n3);
                    string = string.trim();
                }
                try {
                    KnownHostEntry knownHostEntry = KnownHostEntry.parseKnownHostEntry(string);
                    if (knownHostEntry != null) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<KnownHostEntry>();
                        }
                        arrayList.add(knownHostEntry);
                    }
                }
                catch (Error | RuntimeException throwable) {
                    throw new StreamCorruptedException("Failed (" + throwable.getClass().getSimpleName() + ") to parse line #" + n2 + " '" + string + "': " + throwable.getMessage());
                }
            }
            string = bufferedReader.readLine();
            ++n2;
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    public static KnownHostEntry parseKnownHostEntry(String string) {
        return KnownHostEntry.parseKnownHostEntry(GenericUtils.isEmpty(string) ? null : new KnownHostEntry(), string);
    }

    public static KnownHostEntry parseKnownHostEntry(KnownHostEntry knownHostEntry, String string) {
        Object object;
        int n2;
        String string2 = GenericUtils.replaceWhitespaceAndTrim(string);
        if (GenericUtils.isEmpty(string2) || string2.charAt(0) == '#') {
            return knownHostEntry;
        }
        knownHostEntry.setConfigLine(string2);
        if (string2.charAt(0) == '@') {
            n2 = string2.indexOf(32);
            ValidateUtils.checkTrue(n2 > 0, "Missing marker name end delimiter in line=%s", (Object)string);
            ValidateUtils.checkTrue(n2 > 1, "No marker name after indicator in line=%s", (Object)string);
            knownHostEntry.setMarker(string2.substring(1, n2));
            string2 = string2.substring(n2 + 1).trim();
        } else {
            knownHostEntry.setMarker(null);
        }
        n2 = string2.indexOf(32);
        ValidateUtils.checkTrue(n2 > 0, "Missing host patterns end delimiter in line=%s", (Object)string);
        String string3 = string2.substring(0, n2);
        string2 = string2.substring(n2 + 1).trim();
        if (string3.charAt(0) == '|') {
            object = (KnownHostHashValue)ValidateUtils.checkNotNull((Object)KnownHostHashValue.parse(string3), "Failed to extract host hash value from line=%s", (Object)string);
            knownHostEntry.setHashedEntry((KnownHostHashValue)object);
            knownHostEntry.setPatterns(null);
        } else {
            knownHostEntry.setHashedEntry(null);
            knownHostEntry.setPatterns(KnownHostEntry.parsePatterns(GenericUtils.split(string3, ',')));
        }
        object = (AuthorizedKeyEntry)ValidateUtils.checkNotNull((Object)AuthorizedKeyEntry.parseAuthorizedKeyEntry(string2), "No valid key entry recovered from line=%s", (Object)string);
        knownHostEntry.setKeyEntry((AuthorizedKeyEntry)object);
        return knownHostEntry;
    }
}

