/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.util.ValidateUtils;

public enum KnownHostDigest implements NamedFactory
{
    SHA1("1", (Factory)BuiltinMacs.hmacsha1);

    public static final Set VALUES;
    private final String name;
    private final Factory factory;

    /*
     * WARNING - void declaration
     */
    private KnownHostDigest() {
        void var4_1;
        void var3_2;
        this.name = ValidateUtils.checkNotNullAndNotEmpty((String)var3_2, "No name");
        this.factory = (Factory)Objects.requireNonNull(var4_1, "No factory");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Mac create() {
        return (Mac)this.factory.create();
    }

    public static KnownHostDigest fromName(String string) {
        return (KnownHostDigest)NamedResource.findByName(string, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(KnownHostDigest.class));
    }
}

