/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.client.config.hosts.HostPatternValue;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public abstract class HostPatternsHolder {
    public static final char WILDCARD_PATTERN = '*';
    public static final String ALL_HOSTS_PATTERN = String.valueOf('*');
    public static final char SINGLE_CHAR_PATTERN = '?';
    public static final char NEGATION_CHAR_PATTERN = '!';
    public static final String PATTERN_CHARS = new String(new char[]{'*', '?', '!'});
    public static final char PORT_VALUE_DELIMITER = ':';
    public static final char NON_STANDARD_PORT_PATTERN_ENCLOSURE_START_DELIM = '[';
    public static final char NON_STANDARD_PORT_PATTERN_ENCLOSURE_END_DELIM = ']';
    private Collection patterns = new LinkedList();

    protected HostPatternsHolder() {
    }

    public Collection getPatterns() {
        return this.patterns;
    }

    public void setPatterns(Collection collection) {
        this.patterns = collection;
    }

    public boolean isHostMatch(String string, int n2) {
        return HostPatternsHolder.isHostMatch(string, n2, this.getPatterns());
    }

    public static boolean isSpecificHostPattern(String string) {
        if (GenericUtils.isEmpty(string)) {
            return false;
        }
        for (int i2 = 0; i2 < PATTERN_CHARS.length(); ++i2) {
            char c2 = PATTERN_CHARS.charAt(i2);
            if (string.indexOf(c2) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isHostMatch(String string, int n2, Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return false;
        }
        boolean bl2 = false;
        for (HostPatternValue hostPatternValue : collection) {
            boolean bl3 = hostPatternValue.isNegated();
            if (bl2 && !bl3 || !HostPatternsHolder.isHostMatch(string, hostPatternValue.getPattern()) || !HostPatternsHolder.isPortMatch(n2, hostPatternValue.getPort())) continue;
            if (bl3) {
                return false;
            }
            bl2 = true;
        }
        return bl2;
    }

    public static boolean isPortMatch(int n2, int n3) {
        return SshConstants.TO_EFFECTIVE_PORT.applyAsInt(n2) == SshConstants.TO_EFFECTIVE_PORT.applyAsInt(n3);
    }

    public static boolean isHostMatch(String string, Pattern pattern) {
        if (GenericUtils.isEmpty(string) || pattern == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static List parsePatterns(CharSequence ... charSequenceArray) {
        return HostPatternsHolder.parsePatterns(GenericUtils.isEmpty(charSequenceArray) ? Collections.emptyList() : Arrays.asList(charSequenceArray));
    }

    public static List parsePatterns(Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        for (CharSequence charSequence : collection) {
            arrayList.add(ValidateUtils.checkNotNull((Object)HostPatternsHolder.toPattern(charSequence), "No pattern for %s", (Object)charSequence));
        }
        return arrayList;
    }

    public static HostPatternValue toPattern(CharSequence charSequence) {
        int n2;
        String string = GenericUtils.replaceWhitespaceAndTrim(Objects.toString(charSequence, null));
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        int n3 = string.length();
        int n4 = 0;
        StringBuilder stringBuilder = new StringBuilder(n3);
        if (string.charAt(0) == '[') {
            n2 = GenericUtils.lastIndexOf(string, ':');
            ValidateUtils.checkTrue(n2 > 0, "Missing non-standard port value delimiter in %s", (Object)string);
            ValidateUtils.checkTrue(n2 < n3 - 1, "Missing non-standard port value number in %s", (Object)string);
            ValidateUtils.checkTrue(string.charAt(n2 - 1) == ']', "Invalid non-standard port value host pattern enclosure delimiters in %s", (Object)string);
            String string2 = string.substring(n2 + 1, n3);
            n4 = Integer.parseInt(string2);
            ValidateUtils.checkTrue(n4 > 0 && n4 <= 65535, "Invalid non-start port value (%d) in %s", n4, string);
            string = string.substring(1, n2 - 1);
            n3 = string.length();
        }
        n2 = 0;
        block6: for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            ValidateUtils.checkTrue(HostPatternsHolder.isValidPatternChar(c2), "Invalid host pattern char in %s", (Object)string);
            switch (c2) {
                case '.': {
                    stringBuilder.append('\\').append(c2);
                    continue block6;
                }
                case '?': {
                    stringBuilder.append('.');
                    continue block6;
                }
                case '*': {
                    stringBuilder.append(".*");
                    continue block6;
                }
                case '!': {
                    ValidateUtils.checkTrue(n2 == 0, "Double negation in %s", (Object)string);
                    ValidateUtils.checkTrue(i2 == 0, "Negation must be 1st char: %s", (Object)string);
                    n2 = 1;
                    continue block6;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        return new HostPatternValue(Pattern.compile(stringBuilder.toString(), 2), n4, n2 != 0);
    }

    public static boolean isValidPatternChar(char c2) {
        if (c2 <= ' ' || c2 >= '~') {
            return false;
        }
        if (c2 >= 'a' && c2 <= 'z') {
            return true;
        }
        if (c2 >= 'A' && c2 <= 'Z') {
            return true;
        }
        if (c2 >= '0' && c2 <= '9') {
            return true;
        }
        if ("-_.:%".indexOf(c2) >= 0) {
            return true;
        }
        return PATTERN_CHARS.indexOf(c2) >= 0;
    }
}

