/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.sshd.client.config.hosts.KnownHostHashValue;
import org.apache.sshd.common.util.GenericUtils;

public class HostPatternValue {
    private Pattern pattern;
    private int port;
    private boolean negated;

    public HostPatternValue() {
    }

    public HostPatternValue(Pattern pattern, boolean bl2) {
        this(pattern, 0, bl2);
    }

    public HostPatternValue(Pattern pattern, int n2, boolean bl2) {
        this.pattern = pattern;
        this.port = n2;
        this.negated = bl2;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean bl2) {
        this.negated = bl2;
    }

    public String toString() {
        Pattern pattern = this.getPattern();
        String string = pattern == null ? null : pattern.pattern();
        StringBuilder stringBuilder = new StringBuilder(GenericUtils.length(string) + 16);
        if (this.isNegated()) {
            stringBuilder.append('!');
        }
        int n2 = this.getPort();
        try {
            KnownHostHashValue.appendHostPattern(stringBuilder, string, n2);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unexpected (" + iOException.getClass().getSimpleName() + ") failure to append host pattern of " + string + ":" + n2 + ": " + iOException.getMessage(), iOException);
        }
        return stringBuilder.toString();
    }
}

