/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.sshd.client.config.hosts.HostConfigEntry$LazyDefaultConfigFileHolder;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.config.hosts.HostPatternsHolder;
import org.apache.sshd.common.auth.MutableUserHolder;
import org.apache.sshd.common.config.ConfigFileReaderSupport;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.PathUtils;
import org.apache.sshd.common.util.io.input.NoCloseInputStream;
import org.apache.sshd.common.util.io.input.NoCloseReader;
import org.apache.sshd.common.util.io.output.NoCloseOutputStream;

public class HostConfigEntry
extends HostPatternsHolder
implements MutableUserHolder {
    public static final String STD_CONFIG_FILENAME = "config";
    public static final String HOST_CONFIG_PROP = "Host";
    public static final String MATCH_CONFIG_PROP = "Match";
    public static final String HOST_NAME_CONFIG_PROP = "HostName";
    public static final String PORT_CONFIG_PROP = "Port";
    public static final String USER_CONFIG_PROP = "User";
    public static final String PROXY_JUMP_CONFIG_PROP = "ProxyJump";
    public static final String IDENTITY_FILE_CONFIG_PROP = "IdentityFile";
    public static final String CERTIFICATE_FILE_CONFIG_PROP = "CertificateFile";
    public static final String EXCLUSIVE_IDENTITIES_CONFIG_PROP = "IdentitiesOnly";
    public static final boolean DEFAULT_EXCLUSIVE_IDENTITIES = false;
    public static final String IDENTITY_AGENT = "IdentityAgent";
    public static final NavigableSet EXPLICIT_PROPERTIES = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, "Host", "HostName", "Port", "User", "IdentityFile", "IdentitiesOnly"));
    public static final String MULTI_VALUE_SEPARATORS = " ,";
    public static final char PATH_MACRO_CHAR = '%';
    public static final char LOCAL_HOME_MACRO = 'd';
    public static final char LOCAL_USER_MACRO = 'u';
    public static final char LOCAL_HOST_MACRO = 'l';
    public static final char REMOTE_HOST_MACRO = 'h';
    public static final char REMOTE_USER_MACRO = 'r';
    public static final char REMOTE_PORT_MACRO = 'p';
    protected String host;
    protected String hostName;
    protected int port;
    protected String username;
    protected String proxyJump;
    protected Boolean exclusiveIdentites;
    protected final Collection identities = new ArrayList();
    protected final Map properties = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    public HostConfigEntry() {
    }

    public HostConfigEntry(String string, String string2, int n2, String string3) {
        this(string, string2, n2, string3, null);
    }

    public HostConfigEntry(String string, String string2, int n2, String string3, String string4) {
        this.setHost(string);
        this.setHostName(string2);
        this.setPort(n2);
        this.setUsername(string3);
        this.setProxyJump(string4);
    }

    public void collate(HostConfigEntry hostConfigEntry) {
        if (this.hostName == null || this.hostName.isEmpty()) {
            this.hostName = hostConfigEntry.hostName;
        }
        if (this.port <= 0) {
            this.port = hostConfigEntry.port;
        }
        if (this.username == null || this.username.isEmpty()) {
            this.username = hostConfigEntry.username;
        }
        if (this.proxyJump == null || this.proxyJump.isEmpty()) {
            this.proxyJump = hostConfigEntry.proxyJump;
        }
        if (this.exclusiveIdentites == null) {
            this.exclusiveIdentites = hostConfigEntry.exclusiveIdentites;
        }
        this.identities.addAll(hostConfigEntry.identities);
        for (Map.Entry entry : hostConfigEntry.properties.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (this.properties.containsKey(string)) {
                if (!string.equalsIgnoreCase(IDENTITY_FILE_CONFIG_PROP) && !string.equalsIgnoreCase(CERTIFICATE_FILE_CONFIG_PROP)) continue;
                this.properties.put(string, (String)this.properties.get(string) + "," + string2);
                continue;
            }
            this.properties.put(string, string2);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
        this.setPatterns(HostConfigEntry.parsePatterns(HostConfigEntry.parseConfigValue(string)));
    }

    public void setHost(Collection collection) {
        this.host = GenericUtils.join((Iterable)ValidateUtils.checkNotNullAndNotEmpty(collection, "No patterns", new Object[0]), ',');
        this.setPatterns(HostConfigEntry.parsePatterns(collection));
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String string) {
        this.hostName = string;
        this.setProperty(HOST_NAME_CONFIG_PROP, string);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n2) {
        this.port = n2;
        if (n2 <= 0) {
            this.properties.remove(PORT_CONFIG_PROP);
        } else {
            this.setProperty(PORT_CONFIG_PROP, String.valueOf(n2));
        }
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String string) {
        this.username = string;
        this.setProperty(USER_CONFIG_PROP, string);
    }

    public String getProxyJump() {
        return this.proxyJump;
    }

    public void setProxyJump(String string) {
        this.proxyJump = string;
        this.setProperty(PROXY_JUMP_CONFIG_PROP, string);
    }

    public Collection getIdentities() {
        return this.identities;
    }

    public void addIdentity(Path path) {
        this.addIdentity(Objects.requireNonNull(path, "No path").toAbsolutePath().normalize().toString());
    }

    public void addIdentity(String string) {
        String string2 = ValidateUtils.checkNotNullAndNotEmpty(string, "No identity provided");
        this.identities.add(string2);
        this.appendPropertyValue(IDENTITY_FILE_CONFIG_PROP, string);
    }

    public void setIdentities(Collection collection) {
        this.identities.clear();
        this.properties.remove(IDENTITY_FILE_CONFIG_PROP);
        if (collection != null) {
            collection.forEach(this::addIdentity);
        }
    }

    public boolean isIdentitiesOnly() {
        return this.exclusiveIdentites == null ? false : this.exclusiveIdentites;
    }

    public void setIdentitiesOnly(boolean bl2) {
        this.exclusiveIdentites = bl2;
        this.setProperty(EXCLUSIVE_IDENTITIES_CONFIG_PROP, Boolean.toString(bl2));
    }

    public Map getProperties() {
        return this.properties;
    }

    public String getProperty(String string) {
        return this.getProperty(string, null);
    }

    public String getProperty(String string, String string2) {
        String string3 = ValidateUtils.checkNotNullAndNotEmpty(string, "No property name");
        Map map = this.getProperties();
        if (MapEntryUtils.isEmpty(map)) {
            return string2;
        }
        String string4 = (String)map.get(string3);
        if (GenericUtils.isEmpty(string4)) {
            return string2;
        }
        return string4;
    }

    public void processProperty(String string, Collection collection) {
        String string2 = ValidateUtils.checkNotNullAndNotEmpty(string, "No property name");
        String string3 = GenericUtils.join((Iterable)collection, ',');
        if (HOST_NAME_CONFIG_PROP.equalsIgnoreCase(string2)) {
            ValidateUtils.checkTrue(GenericUtils.size(collection) == 1, "Multiple target hosts N/A: %s", (Object)string3);
            this.setHostName(string3);
        } else if (PORT_CONFIG_PROP.equalsIgnoreCase(string2)) {
            ValidateUtils.checkTrue(GenericUtils.size(collection) == 1, "Multiple target ports N/A: %s", (Object)string3);
            int n2 = Integer.parseInt(string3);
            ValidateUtils.checkTrue(n2 > 0, "Bad new port value: %d", n2);
            this.setPort(n2);
        } else if (USER_CONFIG_PROP.equalsIgnoreCase(string2)) {
            ValidateUtils.checkTrue(GenericUtils.size(collection) == 1, "Multiple target users N/A: %s", (Object)string3);
            this.setUsername(string3);
        } else if (IDENTITY_FILE_CONFIG_PROP.equalsIgnoreCase(string2)) {
            ValidateUtils.checkTrue(GenericUtils.size(collection) > 0, "No identity files specified");
            for (String string4 : collection) {
                this.addIdentity(string4);
            }
        } else if (EXCLUSIVE_IDENTITIES_CONFIG_PROP.equalsIgnoreCase(string2)) {
            this.setIdentitiesOnly(ConfigFileReaderSupport.parseBooleanValue(ValidateUtils.checkNotNullAndNotEmpty(string3, "No identities option value")));
        } else if (PROXY_JUMP_CONFIG_PROP.equalsIgnoreCase(string2)) {
            this.setProxyJump(string3);
        } else if (CERTIFICATE_FILE_CONFIG_PROP.equalsIgnoreCase(string2)) {
            this.appendPropertyValue(string2, string3);
        } else {
            this.properties.put(string2, string3);
        }
    }

    public String appendPropertyValue(String string, String string2) {
        String string3 = ValidateUtils.checkNotNullAndNotEmpty(string, "No property name");
        String string4 = this.getProperty(string3);
        if (GenericUtils.isEmpty(string2)) {
            return string4;
        }
        if (GenericUtils.isEmpty(string4)) {
            return this.setProperty(string3, string2);
        }
        return this.setProperty(string3, string4 + ',' + string2);
    }

    public String setProperty(String string, String string2) {
        if (GenericUtils.isEmpty(string2)) {
            return this.removeProperty(string);
        }
        String string3 = ValidateUtils.checkNotNullAndNotEmpty(string, "No property name");
        return this.properties.put(string3, string2);
    }

    public String removeProperty(String string) {
        String string2 = ValidateUtils.checkNotNullAndNotEmpty(string, "No property name");
        Map map = this.getProperties();
        if (MapEntryUtils.isEmpty(map)) {
            return null;
        }
        return (String)map.remove(string2);
    }

    public void setProperties(Map map) {
        this.properties.clear();
        if (map != null) {
            this.properties.putAll(map);
        }
    }

    public Appendable append(Appendable appendable) {
        appendable.append(HOST_CONFIG_PROP).append(' ').append(ValidateUtils.checkNotNullAndNotEmpty(this.getHost(), "No host pattern")).append(IoUtils.EOL);
        HostConfigEntry.appendNonEmptyProperty(appendable, HOST_NAME_CONFIG_PROP, this.getHostName());
        HostConfigEntry.appendNonEmptyPort(appendable, PORT_CONFIG_PROP, this.getPort());
        HostConfigEntry.appendNonEmptyProperty(appendable, USER_CONFIG_PROP, this.getUsername());
        HostConfigEntry.appendNonEmptyValues(appendable, IDENTITY_FILE_CONFIG_PROP, this.getIdentities());
        if (this.exclusiveIdentites != null) {
            HostConfigEntry.appendNonEmptyProperty(appendable, EXCLUSIVE_IDENTITIES_CONFIG_PROP, ConfigFileReaderSupport.yesNoValueOf(this.exclusiveIdentites));
        }
        HostConfigEntry.appendNonEmptyProperties(appendable, this.getProperties());
        return appendable;
    }

    public String toString() {
        return this.getHost() + ": " + this.getUsername() + "@" + this.getHostName() + ":" + this.getPort();
    }

    public static Appendable appendNonEmptyPort(Appendable appendable, String string, int n2) {
        return HostConfigEntry.appendNonEmptyProperty(appendable, string, n2 > 0 ? Integer.toString(n2) : null);
    }

    public static Appendable appendNonEmptyProperties(Appendable appendable, Map map) {
        if (MapEntryUtils.isEmpty(map)) {
            return appendable;
        }
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            if (EXPLICIT_PROPERTIES.contains(string)) continue;
            HostConfigEntry.appendNonEmptyProperty(appendable, string, entry.getValue());
        }
        return appendable;
    }

    public static Appendable appendNonEmptyProperty(Appendable appendable, String string, Object object) {
        String string2 = Objects.toString(object, null);
        String[] stringArray = GenericUtils.split(string2, ',');
        return HostConfigEntry.appendNonEmptyValues(appendable, string, stringArray);
    }

    public static Appendable appendNonEmptyValues(Appendable appendable, String string, Object ... objectArray) {
        return HostConfigEntry.appendNonEmptyValues(appendable, string, GenericUtils.isEmpty(objectArray) ? Collections.emptyList() : Arrays.asList(objectArray));
    }

    public static Appendable appendNonEmptyValues(Appendable appendable, String string, Collection collection) {
        String string2 = ValidateUtils.checkNotNullAndNotEmpty(string, "No property name");
        if (GenericUtils.isEmpty(collection)) {
            return appendable;
        }
        for (Object e2 : collection) {
            appendable.append("    ").append(string2).append(' ').append(Objects.toString(e2)).append(IoUtils.EOL);
        }
        return appendable;
    }

    public static List findMatchingEntries(String string, HostConfigEntry ... hostConfigEntryArray) {
        if (GenericUtils.isEmpty(string) || GenericUtils.isEmpty(hostConfigEntryArray)) {
            return Collections.emptyList();
        }
        return HostConfigEntry.findMatchingEntries(string, Arrays.asList(hostConfigEntryArray));
    }

    public static List findMatchingEntries(String string, Collection collection) {
        if (GenericUtils.isEmpty(string) || GenericUtils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        ArrayList<HostConfigEntry> arrayList = null;
        for (HostConfigEntry hostConfigEntry : collection) {
            if (!hostConfigEntry.isHostMatch(string, 0)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<HostConfigEntry>(collection.size());
            }
            arrayList.add(hostConfigEntry);
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    public static HostConfigEntryResolver toHostConfigEntryResolver(Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return HostConfigEntryResolver.EMPTY;
        }
        return (string, n2, socketAddress, string2, string3, attributeRepository) -> {
            Object object;
            Object object2;
            ArrayList arrayList22;
            List list = HostConfigEntry.findMatchingEntries(string, collection);
            int n3 = GenericUtils.size(list);
            if (n3 <= 0) {
                return null;
            }
            HostConfigEntry hostConfigEntry = new HostConfigEntry(string, null, n2, string2);
            for (ArrayList arrayList22 : list) {
                hostConfigEntry.collate((HostConfigEntry)((Object)arrayList22));
            }
            Object object3 = hostConfigEntry.getHostName();
            if (object3 == null || ((String)object3).isEmpty()) {
                hostConfigEntry.setHostName(string);
            }
            if ((object3 = hostConfigEntry.getUsername()) == null || ((String)object3).isEmpty()) {
                hostConfigEntry.setUsername(OsUtils.getCurrentUser());
            }
            if (hostConfigEntry.getPort() < 1) {
                hostConfigEntry.setPort(22);
            }
            if (!GenericUtils.isEmpty(arrayList22 = hostConfigEntry.getIdentities())) {
                arrayList22 = new ArrayList(arrayList22);
                hostConfigEntry.setIdentities(Collections.emptyList());
                object2 = arrayList22.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    hostConfigEntry.addIdentity(HostConfigEntry.resolveIdentityFilePath((String)object, hostConfigEntry.getHostName(), hostConfigEntry.getPort(), hostConfigEntry.getUsername()));
                }
            }
            if (!GenericUtils.isEmpty((CharSequence)(object2 = hostConfigEntry.getProperty(CERTIFICATE_FILE_CONFIG_PROP)))) {
                hostConfigEntry.removeProperty(CERTIFICATE_FILE_CONFIG_PROP);
                object = ((String)object2).split(",");
                ArrayList<String> arrayList3 = new ArrayList<String>(((String[])object).length);
                for (String string4 : object) {
                    arrayList3.add(HostConfigEntry.resolveIdentityFilePath(string4, hostConfigEntry.getHostName(), hostConfigEntry.getPort(), hostConfigEntry.getUsername()));
                }
                hostConfigEntry.processProperty(CERTIFICATE_FILE_CONFIG_PROP, arrayList3);
            }
            return hostConfigEntry;
        };
    }

    public static List readHostConfigEntries(Path path, OpenOption ... openOptionArray) {
        try (InputStream inputStream = Files.newInputStream(path, openOptionArray);){
            List list = HostConfigEntry.readHostConfigEntries(inputStream, true);
            return list;
        }
    }

    public static List readHostConfigEntries(URL uRL) {
        try (InputStream inputStream = uRL.openStream();){
            List list = HostConfigEntry.readHostConfigEntries(inputStream, true);
            return list;
        }
    }

    public static List readHostConfigEntries(InputStream inputStream, boolean bl2) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(NoCloseInputStream.resolveInputStream(inputStream, bl2), StandardCharsets.UTF_8);){
            List list = HostConfigEntry.readHostConfigEntries(inputStreamReader, true);
            return list;
        }
    }

    public static List readHostConfigEntries(Reader reader, boolean bl2) {
        try (BufferedReader bufferedReader = new BufferedReader(NoCloseReader.resolveReader(reader, bl2));){
            List list = HostConfigEntry.readHostConfigEntries(bufferedReader);
            return list;
        }
    }

    public static List readHostConfigEntries(BufferedReader bufferedReader) {
        HostConfigEntry hostConfigEntry = null;
        ArrayList<HostConfigEntry> arrayList = new ArrayList<HostConfigEntry>();
        int n2 = 1;
        String string = bufferedReader.readLine();
        while (string != null) {
            int n3;
            if (!GenericUtils.isEmpty(string = GenericUtils.replaceWhitespaceAndTrim(string)) && (n3 = string.indexOf(35)) != 0) {
                List<String> list;
                String string2;
                String string3;
                if (n3 > 0) {
                    string = string.substring(0, n3);
                    string = string.trim();
                }
                if ((n3 = string.indexOf(61)) > 0) {
                    string3 = string.substring(0, n3).trim();
                    string2 = string.substring(n3 + 1);
                    list = new ArrayList<String>(1);
                    list.add(string2);
                } else {
                    n3 = string.indexOf(32);
                    if (n3 < 0) {
                        throw new StreamCorruptedException("No configuration value delimiter at line " + n2 + ": " + string);
                    }
                    string3 = string.substring(0, n3);
                    string2 = string.substring(n3 + 1);
                    list = GenericUtils.filterToNotBlank(HostConfigEntry.parseConfigValue(string2));
                }
                if (HOST_CONFIG_PROP.equalsIgnoreCase(string3)) {
                    if (GenericUtils.isEmpty(list)) {
                        throw new StreamCorruptedException("Missing host pattern(s) at line " + n2 + ": " + string);
                    }
                    if (hostConfigEntry != null) {
                        arrayList.add(hostConfigEntry);
                    }
                    hostConfigEntry = new HostConfigEntry();
                    hostConfigEntry.setHost(list);
                } else {
                    if (MATCH_CONFIG_PROP.equalsIgnoreCase(string3)) {
                        throw new StreamCorruptedException("Currently not able to process Match sections");
                    }
                    if (hostConfigEntry == null) {
                        hostConfigEntry = new HostConfigEntry();
                        hostConfigEntry.setHost(Collections.singletonList(ALL_HOSTS_PATTERN));
                    }
                }
                String string4 = GenericUtils.join(list, ',');
                hostConfigEntry.appendPropertyValue(string3, string4);
                hostConfigEntry.processProperty(string3, list);
            }
            string = bufferedReader.readLine();
            ++n2;
        }
        if (hostConfigEntry != null) {
            arrayList.add(hostConfigEntry);
        }
        return arrayList;
    }

    public static void writeHostConfigEntries(Path path, Collection collection, OpenOption ... openOptionArray) {
        try (OutputStream outputStream = Files.newOutputStream(path, openOptionArray);){
            HostConfigEntry.writeHostConfigEntries(outputStream, true, collection);
        }
    }

    public static void writeHostConfigEntries(OutputStream outputStream, boolean bl2, Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return;
        }
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(NoCloseOutputStream.resolveOutputStream(outputStream, bl2), StandardCharsets.UTF_8);){
            HostConfigEntry.appendHostConfigEntries(outputStreamWriter, collection);
        }
    }

    public static Appendable appendHostConfigEntries(Appendable appendable, Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return appendable;
        }
        for (HostConfigEntry hostConfigEntry : collection) {
            hostConfigEntry.append(appendable);
        }
        return appendable;
    }

    public static List parseConfigValue(String string) {
        String string2 = GenericUtils.replaceWhitespaceAndTrim(string);
        if (GenericUtils.isEmpty(string2)) {
            return Collections.emptyList();
        }
        for (int i2 = 0; i2 < MULTI_VALUE_SEPARATORS.length(); ++i2) {
            char c2 = MULTI_VALUE_SEPARATORS.charAt(i2);
            int n2 = string2.indexOf(c2);
            if (n2 < 0) continue;
            Object[] objectArray = GenericUtils.split(string2, c2);
            if (GenericUtils.isEmpty(objectArray)) {
                return Collections.emptyList();
            }
            return Arrays.asList(objectArray);
        }
        return Collections.singletonList(string2);
    }

    public static String resolveIdentityFilePath(String string, String string2, int n2, String string3) {
        if (GenericUtils.isEmpty(string)) {
            return string;
        }
        String string4 = string.replace('/', File.separatorChar);
        String[] stringArray = GenericUtils.split(string4, File.separatorChar);
        StringBuilder stringBuilder = new StringBuilder(string4.length() + 64);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string5 = stringArray[i2];
            if (i2 > 0) {
                stringBuilder.append(File.separatorChar);
            }
            for (int i3 = 0; i3 < string5.length(); ++i3) {
                char c2 = string5.charAt(i3);
                if (c2 == '~') {
                    ValidateUtils.checkTrue(i3 == 0 && i2 == 0, "Home tilde must be first: %s", (Object)string);
                    PathUtils.appendUserHome(stringBuilder);
                    continue;
                }
                if (c2 == '%') {
                    ValidateUtils.checkTrue(++i3 < string5.length(), "Missing macro modifier in %s", (Object)string);
                    c2 = string5.charAt(i3);
                    switch (c2) {
                        case '%': {
                            stringBuilder.append(c2);
                            break;
                        }
                        case 'd': {
                            ValidateUtils.checkTrue(i3 == 1 && i2 == 0, "Home macro must be first: %s", (Object)string);
                            PathUtils.appendUserHome(stringBuilder);
                            break;
                        }
                        case 'u': {
                            stringBuilder.append(ValidateUtils.checkNotNullAndNotEmpty(OsUtils.getCurrentUser(), "No local user name value"));
                            break;
                        }
                        case 'l': {
                            InetAddress inetAddress = Objects.requireNonNull(InetAddress.getLocalHost(), "No local address");
                            stringBuilder.append(ValidateUtils.checkNotNullAndNotEmpty(inetAddress.getHostName(), "No local name"));
                            break;
                        }
                        case 'h': {
                            stringBuilder.append(ValidateUtils.checkNotNullAndNotEmpty(string2, "No remote host provided"));
                            break;
                        }
                        case 'r': {
                            stringBuilder.append(ValidateUtils.checkNotNullAndNotEmpty(string3, "No remote user provided"));
                            break;
                        }
                        case 'p': {
                            ValidateUtils.checkTrue(n2 > 0, "Bad remote port value: %d", n2);
                            stringBuilder.append(n2);
                            break;
                        }
                        default: {
                            ValidateUtils.throwIllegalArgumentException("Bad modifier '%s' in %s", String.valueOf(c2), string);
                            break;
                        }
                    }
                    continue;
                }
                stringBuilder.append(c2);
            }
        }
        return stringBuilder.toString();
    }

    public static Path getDefaultHostConfigFile() {
        return HostConfigEntry$LazyDefaultConfigFileHolder.access$000();
    }
}

