/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.client.config.hosts.ConfigFileHostEntryResolver;
import org.apache.sshd.client.config.hosts.HostConfigEntry;

public class DefaultConfigFileHostEntryResolver
extends ConfigFileHostEntryResolver {
    public static final DefaultConfigFileHostEntryResolver INSTANCE = new DefaultConfigFileHostEntryResolver(true);
    private final boolean strict;

    public DefaultConfigFileHostEntryResolver(boolean bl2) {
        this(HostConfigEntry.getDefaultHostConfigFile(), bl2, new LinkOption[0]);
    }

    public DefaultConfigFileHostEntryResolver(Path path, boolean bl2, LinkOption ... linkOptionArray) {
        super(path, linkOptionArray);
        this.strict = bl2;
    }

    public final boolean isStrict() {
        return this.strict;
    }

    @Override
    protected List reloadHostConfigEntries(Path path, String string, int n2, String string2, String string3) {
        if (this.isStrict()) {
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry;
            if (this.log.isDebugEnabled()) {
                this.log.debug("reloadHostConfigEntries({}@{}:{}/{}) check permissions of {}", new Object[]{string2, string, n2, string3, path});
            }
            if ((simpleImmutableEntry = DefaultConfigFileHostEntryResolver.validateStrictConfigFilePermissions(path, new LinkOption[0])) != null) {
                this.log.warn("reloadHostConfigEntries({}@{}:{}/{}) invalid file={} permissions: {}", new Object[]{string2, string, n2, string3, path, simpleImmutableEntry.getKey()});
                this.updateReloadAttributes();
                return Collections.emptyList();
            }
        }
        return super.reloadHostConfigEntries(path, string, n2, string2, string3);
    }
}

