/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;

public class ConfigFileHostEntryResolver
extends ModifiableFileWatcher
implements HostConfigEntryResolver {
    private final AtomicReference delegateHolder = new AtomicReference<HostConfigEntryResolver>(HostConfigEntryResolver.EMPTY);

    public ConfigFileHostEntryResolver(Path path) {
        this(path, IoUtils.EMPTY_LINK_OPTIONS);
    }

    public ConfigFileHostEntryResolver(Path path, LinkOption ... linkOptionArray) {
        super(path, linkOptionArray);
    }

    @Override
    public HostConfigEntry resolveEffectiveHost(String string, int n2, SocketAddress socketAddress, String string2, String string3, AttributeRepository attributeRepository) {
        try {
            HostConfigEntryResolver hostConfigEntryResolver = Objects.requireNonNull(this.resolveEffectiveResolver(string, n2, string2, string3), "No delegate");
            HostConfigEntry hostConfigEntry = hostConfigEntryResolver.resolveEffectiveHost(string, n2, socketAddress, string2, string3, attributeRepository);
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveEffectiveHost({}@{}:{}/{}) => {}", new Object[]{string2, string, n2, string3, hostConfigEntry});
            }
            return hostConfigEntry;
        }
        catch (Throwable throwable) {
            this.debug("resolveEffectiveHost({}@{}:{}/{}) failed ({}) to resolve: {}", string2, string, n2, string3, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(throwable);
        }
    }

    protected HostConfigEntryResolver resolveEffectiveResolver(String string, int n2, String string2, String string3) {
        if (this.checkReloadRequired()) {
            this.delegateHolder.set(HostConfigEntryResolver.EMPTY);
            Path path = this.getPath();
            if (this.exists()) {
                List list = this.reloadHostConfigEntries(path, string, n2, string2, string3);
                if (GenericUtils.size(list) > 0) {
                    this.delegateHolder.set(HostConfigEntry.toHostConfigEntryResolver(list));
                }
            } else {
                this.log.info("resolveEffectiveResolver({}@{}:{}/{}) no configuration file at {}", new Object[]{string2, string, n2, string3, path});
            }
        }
        return (HostConfigEntryResolver)this.delegateHolder.get();
    }

    protected List reloadHostConfigEntries(Path path, String string, int n2, String string2, String string3) {
        List list = HostConfigEntry.readHostConfigEntries(path, new OpenOption[0]);
        this.log.info("resolveEffectiveResolver({}@{}:{}) loaded {} entries from {}", new Object[]{string2, string, n2, GenericUtils.size(list), path});
        this.updateReloadAttributes();
        return list;
    }
}

