/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config;

import java.time.Duration;
import java.util.Map;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.common.CommonModuleProperties;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.SshConfigFileReader;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.session.SessionHeartbeatController$HeartbeatType;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.core.CoreModuleProperties;

public final class SshClientConfigFileReader {
    public static final String SETENV_PROP = "SetEnv";
    public static final String SENDENV_PROP = "SendEnv";
    public static final String REQUEST_TTY_OPTION = "RequestTTY";
    public static final Property CLIENT_LIVECHECK_INTERVAL_PROP = Property.duration("ClientAliveInterval", Duration.ZERO);
    public static final Property CLIENT_LIVECHECK_USE_NULLS = Property.bool("ClientAliveUseNullPackets", false);
    public static final Property CLIENT_LIVECHECK_REPLIES_WAIT = Property.duration("ClientAliveReplyWait", Duration.ZERO);
    public static final long DEFAULT_LIVECHECK_REPLY_WAIT = 0L;

    private SshClientConfigFileReader() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static SshClient setupClientHeartbeat(SshClient sshClient, PropertyResolver propertyResolver) {
        if (sshClient == null || propertyResolver == null) {
            return sshClient;
        }
        Duration duration = (Duration)CLIENT_LIVECHECK_INTERVAL_PROP.getRequired(propertyResolver);
        if (GenericUtils.isNegativeOrNull(duration)) {
            return sshClient;
        }
        if (((Boolean)CLIENT_LIVECHECK_USE_NULLS.getRequired(propertyResolver)).booleanValue()) {
            CommonModuleProperties.SESSION_HEARTBEAT_TYPE.set(sshClient, (Object)SessionHeartbeatController$HeartbeatType.IGNORE);
            CommonModuleProperties.SESSION_HEARTBEAT_INTERVAL.set(sshClient, duration);
        } else {
            CoreModuleProperties.HEARTBEAT_INTERVAL.set(sshClient, duration);
            duration = (Duration)CLIENT_LIVECHECK_REPLIES_WAIT.getRequired(propertyResolver);
            if (!GenericUtils.isNegativeOrNull(duration)) {
                CoreModuleProperties.HEARTBEAT_REPLY_WAIT.set(sshClient, duration);
            }
        }
        return sshClient;
    }

    public static SshClient setupClientHeartbeat(SshClient sshClient, Map map) {
        if (sshClient == null || MapEntryUtils.isEmpty(map)) {
            return sshClient;
        }
        return SshClientConfigFileReader.setupClientHeartbeat(sshClient, PropertyResolverUtils.toPropertyResolver(map));
    }

    public static SshClient configure(SshClient sshClient, PropertyResolver propertyResolver, boolean bl2, boolean bl3) {
        SshConfigFileReader.configure(sshClient, propertyResolver, bl2, bl3);
        SshConfigFileReader.configureKeyExchanges((AbstractFactoryManager)sshClient, propertyResolver, bl2, ClientBuilder.DH2KEX, bl3);
        SshClientConfigFileReader.setupClientHeartbeat(sshClient, propertyResolver);
        return sshClient;
    }
}

