/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel.exit;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.channel.AbstractChannelRequestHandler;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.RequestHandler$Result;
import org.apache.sshd.common.util.EventNotifier;
import org.apache.sshd.common.util.buffer.Buffer;

public abstract class AbstractChannelExitRequestHandler
extends AbstractChannelRequestHandler
implements NamedResource {
    protected final AtomicReference holder;
    protected final EventNotifier notifier;

    protected AbstractChannelExitRequestHandler(AtomicReference atomicReference, EventNotifier eventNotifier) {
        this.holder = Objects.requireNonNull(atomicReference, "No exit status holder");
        this.notifier = Objects.requireNonNull(eventNotifier, "No event notifier");
    }

    @Override
    public RequestHandler$Result process(Channel channel, String string, boolean bl2, Buffer buffer) {
        Object object;
        String string2 = this.getName();
        if (string2.equals(string) && (object = this.processRequestValue(channel, string, buffer)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("process({})[{}] wantReply={}: {}", new Object[]{channel, string, bl2, object});
            }
            this.holder.set(object);
            this.notifyStateChanged(channel, string, object);
            return RequestHandler$Result.ReplySuccess;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("process({}) wantReply={} ignore request={}", new Object[]{channel, bl2, string});
        }
        return RequestHandler$Result.Unsupported;
    }

    protected abstract Object processRequestValue(Channel var1, String var2, Buffer var3);

    protected void notifyStateChanged(Channel channel, String string, Object object) {
        String string2 = this.getEvent(channel, string, object);
        try {
            this.notifier.notifyEvent(string2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("notifyStateChanged({})[{}] event={}", new Object[]{channel, string, string2});
            }
        }
        catch (Exception exception) {
            this.warn("notifyStateChanged({})[{}] Failed ({}) to notify event={}: {}", channel, string, exception.getClass().getSimpleName(), string2, exception.getMessage(), exception);
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new IllegalArgumentException(exception);
        }
    }

    protected String getEvent(Channel channel, String string, Object object) {
        return this.getName();
    }
}

