/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.util.Collections;
import java.util.Map;
import org.apache.sshd.client.channel.ChannelSession;
import org.apache.sshd.common.channel.PtyChannelConfiguration;
import org.apache.sshd.common.channel.PtyChannelConfigurationHolder;
import org.apache.sshd.common.channel.PtyChannelConfigurationMutator;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.core.CoreModuleProperties;

public class PtyCapableChannelSession
extends ChannelSession
implements PtyChannelConfigurationMutator {
    private boolean agentForwarding;
    private boolean usePty;
    private final PtyChannelConfiguration config;

    public PtyCapableChannelSession(boolean bl2, PtyChannelConfigurationHolder ptyChannelConfigurationHolder, Map map) {
        this.usePty = bl2;
        this.config = (PtyChannelConfiguration)PtyChannelConfigurationMutator.copyConfiguration(ptyChannelConfigurationHolder, new PtyChannelConfiguration());
        this.config.setPtyType(this.resolvePtyType(this.config));
        if (MapEntryUtils.isNotEmpty(map)) {
            for (Map.Entry entry : map.entrySet()) {
                this.setEnv((String)entry.getKey(), entry.getValue());
            }
        }
    }

    protected String resolvePtyType(PtyChannelConfigurationHolder ptyChannelConfigurationHolder) {
        String string = ptyChannelConfigurationHolder.getPtyType();
        if (GenericUtils.isNotEmpty(string)) {
            return string;
        }
        string = System.getenv("TERM");
        if (GenericUtils.isNotEmpty(string)) {
            return string;
        }
        return "dummy";
    }

    public void setupSensibleDefaultPty() {
        try {
            PtyChannelConfigurationMutator.setupSensitiveDefaultPtyConfiguration(this);
        }
        catch (Throwable throwable) {
            this.debug("setupSensibleDefaultPty({}) Failed ({}) to setup: {}", this, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
        }
    }

    public boolean isAgentForwarding() {
        return this.agentForwarding;
    }

    public void setAgentForwarding(boolean bl2) {
        this.agentForwarding = bl2;
    }

    public boolean isUsePty() {
        return this.usePty;
    }

    public void setUsePty(boolean bl2) {
        this.usePty = bl2;
    }

    @Override
    public String getPtyType() {
        return this.config.getPtyType();
    }

    @Override
    public void setPtyType(String string) {
        this.config.setPtyType(string);
    }

    @Override
    public int getPtyColumns() {
        return this.config.getPtyColumns();
    }

    @Override
    public void setPtyColumns(int n2) {
        this.config.setPtyColumns(n2);
    }

    @Override
    public int getPtyLines() {
        return this.config.getPtyLines();
    }

    @Override
    public void setPtyLines(int n2) {
        this.config.setPtyLines(n2);
    }

    @Override
    public int getPtyWidth() {
        return this.config.getPtyWidth();
    }

    @Override
    public void setPtyWidth(int n2) {
        this.config.setPtyWidth(n2);
    }

    @Override
    public int getPtyHeight() {
        return this.config.getPtyHeight();
    }

    @Override
    public void setPtyHeight(int n2) {
        this.config.setPtyHeight(n2);
    }

    @Override
    public Map getPtyModes() {
        return this.config.getPtyModes();
    }

    @Override
    public void setPtyModes(Map map) {
        this.config.setPtyModes(map == null ? Collections.emptyMap() : map);
    }

    public void sendWindowChange(int n2, int n3) {
        this.sendWindowChange(n2, n3, this.getPtyHeight(), this.getPtyWidth());
    }

    public void sendWindowChange(int n2, int n3, int n4, int n5) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendWindowChange({}) cols={}, lines={}, height={}, width={}", new Object[]{this, n2, n3, n4, n5});
        }
        this.setPtyColumns(n2);
        this.setPtyLines(n3);
        this.setPtyHeight(n4);
        this.setPtyWidth(n5);
        Session session = this.getSession();
        Buffer buffer = session.createBuffer((byte)98, 64);
        buffer.putUInt(this.getRecipient());
        buffer.putString("window-change");
        buffer.putBoolean(false);
        buffer.putInt(this.getPtyColumns());
        buffer.putInt(this.getPtyLines());
        buffer.putInt(this.getPtyHeight());
        buffer.putInt(this.getPtyWidth());
        this.writePacket(buffer);
    }

    protected void doOpenPty() {
        Object object;
        Object object2;
        Session session = this.getSession();
        boolean bl2 = this.log.isDebugEnabled();
        if (this.agentForwarding) {
            if (bl2) {
                this.log.debug("doOpenPty({}) Send agent forwarding request", (Object)this);
            }
            object2 = (String)CoreModuleProperties.PROXY_AUTH_CHANNEL_TYPE.getRequired(session);
            object = session.createBuffer((byte)98, 64);
            ((Buffer)object).putInt(this.getRecipient());
            ((Buffer)object).putString((String)object2);
            ((Buffer)object).putBoolean(false);
            this.writePacket((Buffer)object);
        }
        if (this.usePty) {
            if (bl2) {
                this.log.debug("doOpenPty({}) Send SSH_MSG_CHANNEL_REQUEST pty-req: {}", (Object)this, (Object)this.config);
            }
            object2 = session.createBuffer((byte)98, 127);
            ((Buffer)object2).putInt(this.getRecipient());
            ((Buffer)object2).putString("pty-req");
            ((Buffer)object2).putBoolean(false);
            ((Buffer)object2).putString(this.getPtyType());
            ((Buffer)object2).putInt(this.getPtyColumns());
            ((Buffer)object2).putInt(this.getPtyLines());
            ((Buffer)object2).putInt(this.getPtyHeight());
            ((Buffer)object2).putInt(this.getPtyWidth());
            object = this.getPtyModes();
            int n3 = MapEntryUtils.size((Map)object);
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(n3 * 5 + 64, false);
            if (n3 > 0) {
                object.forEach((ptyMode, n2) -> {
                    byteArrayBuffer.putByte((byte)ptyMode.toInt());
                    byteArrayBuffer.putUInt(n2.longValue());
                });
            }
            ((Buffer)byteArrayBuffer).putByte((byte)0);
            ((Buffer)object2).putBytes(byteArrayBuffer.getCompactData());
            this.writePacket((Buffer)object2);
        }
        this.sendEnvVariables(session);
    }
}

