/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.StreamingChannel;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoOutputStream;

public interface ClientChannel
extends ClientSessionHolder,
Channel,
StreamingChannel {
    @Override
    default public ClientSession getClientSession() {
        return (ClientSession)this.getSession();
    }

    public String getChannelType();

    public IoOutputStream getAsyncIn();

    public IoInputStream getAsyncOut();

    public IoInputStream getAsyncErr();

    public OutputStream getInvertedIn();

    public InputStream getInvertedOut();

    public InputStream getInvertedErr();

    public void setIn(InputStream var1);

    public void setOut(OutputStream var1);

    public void setErr(OutputStream var1);

    public void setRedirectErrorStream(boolean var1);

    public OpenFuture open();

    public Set getChannelState();

    public Set waitFor(Collection var1, long var2);

    default public Set waitFor(Collection collection, Duration duration) {
        return this.waitFor(collection, duration != null ? duration.toMillis() : -1L);
    }

    public Integer getExitStatus();

    public String getExitSignal();

    public static void validateCommandExitStatusCode(String string, Integer n2) {
        if (n2 == null) {
            throw new RemoteException("No exit status returned for command=" + string);
        }
        if (n2 != 0) {
            throw new RemoteException("Remote command failed (" + n2 + "): " + string, new ServerException(n2.toString()));
        }
    }
}

