/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.util.Date;
import org.apache.sshd.client.channel.ChannelSession;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.core.CoreModuleProperties;

public class ChannelSubsystem
extends ChannelSession {
    private final String subsystem;

    public ChannelSubsystem(String string) {
        this.subsystem = ValidateUtils.checkNotNullAndNotEmpty(string, "Subsystem may not be null/empty");
    }

    public final String getSubsystem() {
        return this.subsystem;
    }

    @Override
    protected void doOpen() {
        String string = this.getSubsystem();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpen({}) SSH_MSG_CHANNEL_REQUEST subsystem={}", (Object)this, (Object)string);
        }
        Session session = this.getSession();
        this.sendEnvVariables(session);
        boolean bl2 = (Boolean)CoreModuleProperties.REQUEST_SUBSYSTEM_REPLY.getRequired(this);
        Buffer buffer = session.createBuffer((byte)98, "subsystem".length() + string.length() + 32);
        buffer.putUInt(this.getRecipient());
        buffer.putString("subsystem");
        buffer.putBoolean(bl2);
        buffer.putString(string);
        this.addPendingRequest("subsystem", bl2);
        this.writePacket(buffer);
        super.doOpen();
    }

    @Override
    public void handleSuccess() {
        String string = this.getSubsystem();
        Date date = this.removePendingRequest("subsystem");
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleSuccess({}) subsystem={}, pending since={}", new Object[]{this, string, date});
        }
    }

    @Override
    public void handleFailure() {
        String string = this.getSubsystem();
        Date date = this.removePendingRequest("subsystem");
        if (date != null) {
            this.log.warn("handleFailure({}) subsystem={}, pending since={}", new Object[]{this, string, date});
            this.close(true);
        }
    }

    public void onClose(Runnable runnable) {
        this.closeFuture.addListener(closeFuture -> runnable.run());
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.getSubsystem() + "]";
    }
}

