/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.util.Date;
import java.util.Map;
import org.apache.sshd.client.channel.PtyCapableChannelSession;
import org.apache.sshd.common.channel.PtyChannelConfigurationHolder;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.core.CoreModuleProperties;

public class ChannelShell
extends PtyCapableChannelSession {
    public ChannelShell(PtyChannelConfigurationHolder ptyChannelConfigurationHolder, Map map) {
        super(true, ptyChannelConfigurationHolder, map);
    }

    @Override
    protected void doOpen() {
        this.doOpenPty();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpen({}) send SSH_MSG_CHANNEL_REQUEST shell", (Object)this);
        }
        Session session = this.getSession();
        boolean bl2 = (Boolean)CoreModuleProperties.REQUEST_SHELL_REPLY.getRequired(this);
        Buffer buffer = session.createBuffer((byte)98, 32);
        buffer.putUInt(this.getRecipient());
        buffer.putString("shell");
        buffer.putBoolean(bl2);
        this.addPendingRequest("shell", bl2);
        this.writePacket(buffer);
        super.doOpen();
    }

    @Override
    public void handleSuccess() {
        Date date = this.removePendingRequest("shell");
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleSuccess({}) pending={}", (Object)this, (Object)date);
        }
    }

    @Override
    public void handleFailure() {
        Date date = this.removePendingRequest("shell");
        if (date != null) {
            this.log.warn("handleFailure({}) pending={}", (Object)this, (Object)date);
            this.close(true);
        }
    }
}

