/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.InputStream;
import java.nio.channels.Channel;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.channel.ChannelSession$1;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.channel.ChannelAsyncInputStream;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.ChannelPipedInputStream;
import org.apache.sshd.common.channel.ChannelPipedOutputStream;
import org.apache.sshd.common.channel.ChannelPipedSink;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.RemoteWindow;
import org.apache.sshd.common.channel.RequestHandler$Result;
import org.apache.sshd.common.channel.StreamingChannel$Streaming;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;

public class ChannelSession
extends AbstractClientChannel {
    protected CloseableExecutorService pumperService;
    protected Future pumper;
    private final Map env = new LinkedHashMap();

    public ChannelSession() {
        super("session");
    }

    @Override
    protected void doOpen() {
        if (StreamingChannel$Streaming.Async.equals((Object)this.streaming)) {
            this.asyncIn = new ChannelSession$1(this, this, 94);
            this.asyncOut = new ChannelAsyncInputStream(this);
            this.asyncErr = this.redirectErrorStream ? this.asyncOut : new ChannelAsyncInputStream(this);
        } else {
            ChannelPipedOutputStream channelPipedOutputStream;
            Channel channel;
            this.invertedIn = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
            LocalWindow localWindow = this.getLocalWindow();
            if (this.out == null) {
                channel = new ChannelPipedInputStream(this, localWindow);
                channelPipedOutputStream = new ChannelPipedOutputStream((ChannelPipedSink)channel);
                this.out = channelPipedOutputStream;
                this.invertedOut = channel;
            }
            if (this.err == null) {
                if (this.redirectErrorStream) {
                    this.err = this.out;
                    this.invertedErr = this.invertedOut;
                } else {
                    channel = new ChannelPipedInputStream(this, localWindow);
                    channelPipedOutputStream = new ChannelPipedOutputStream((ChannelPipedSink)channel);
                    this.err = channelPipedOutputStream;
                    this.invertedErr = channel;
                }
            }
            if (this.in != null) {
                channel = this.getExecutorService();
                this.pumperService = channel == null ? ThreadUtils.newSingleThreadExecutor("ClientInputStreamPump[" + Math.abs(System.nanoTime() & 0xFFFFL) + "]") : ThreadUtils.noClose((CloseableExecutorService)channel);
                this.pumper = this.pumperService.submit(this::pumpInputStream);
            }
        }
    }

    @Override
    protected RequestHandler$Result handleInternalRequest(String string, boolean bl2, Buffer buffer) {
        switch (string) {
            case "xon-xoff": {
                return this.handleXonXoff(buffer, bl2);
            }
        }
        return super.handleInternalRequest(string, bl2, buffer);
    }

    protected RequestHandler$Result handleXonXoff(Buffer buffer, boolean bl2) {
        boolean bl3 = buffer.getBoolean();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleXonXoff({})[want-reply={}] client-can-do={}", new Object[]{this, bl2, bl3});
        }
        return RequestHandler$Result.ReplySuccess;
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(super.getInnerCloseable()).run(this.toString(), this::closeImmediately0).build();
    }

    protected void closeImmediately0() {
        if (this.pumper != null && this.pumperService != null && !this.pumperService.isShutdown()) {
            try {
                if (!this.pumper.isDone()) {
                    this.pumper.cancel(true);
                }
                this.pumperService.shutdownNow();
            }
            catch (Exception exception) {
                this.warn("doCloseImmediately({}) failed {} to shutdown stream pumper: {}", this, exception.getClass().getSimpleName(), exception.getMessage(), exception);
            }
            finally {
                this.pumper = null;
                this.pumperService = null;
            }
        }
    }

    protected void pumpInputStream() {
        block6: {
            boolean bl2 = this.log.isDebugEnabled();
            try {
                Session session = this.getSession();
                RemoteWindow remoteWindow = this.getRemoteWindow();
                long l2 = remoteWindow.getPacketSize();
                ValidateUtils.checkTrue(l2 > 0L && l2 < Integer.MAX_VALUE, "Invalid remote packet size int boundary: %d", l2);
                byte[] byArray = new byte[(int)l2];
                int n2 = (Integer)CoreModuleProperties.INPUT_STREAM_PUMP_CHUNK_SIZE.getRequired(session);
                n2 = Math.max(n2, (Integer)CoreModuleProperties.INPUT_STREAM_PUMP_CHUNK_SIZE.getRequiredDefault());
                while (!this.closeFuture.isClosed()) {
                    int n3 = this.securedRead(this.in, n2, byArray, 0, byArray.length);
                    if (n3 < 0) {
                        if (bl2) {
                            this.log.debug("pumpInputStream({}) EOF signalled", (Object)this);
                        }
                        this.sendEof();
                        return;
                    }
                    session.resetIdleTimeout();
                    if (n3 <= 0) continue;
                    this.invertedIn.write(byArray, 0, n3);
                    this.invertedIn.flush();
                }
                if (bl2) {
                    this.log.debug("pumpInputStream({}) close future closed", (Object)this);
                }
            }
            catch (Exception exception) {
                if (this.isClosing()) break block6;
                this.error("pumpInputStream({}) Caught {} : {}", this, exception.getClass().getSimpleName(), exception.getMessage(), exception);
                this.close(false);
            }
        }
    }

    protected int securedRead(InputStream inputStream, int n2, byte[] byArray, int n3, int n4) {
        int n5;
        int n6 = 0;
        do {
            int n7;
            if ((n7 = inputStream.read(byArray, n3 + n6, Math.min(n2, n4 - n6))) <= 0) {
                return n6 == 0 ? n7 : n6;
            }
            if ((n6 += n7) < n4) continue;
            return n6;
        } while ((n5 = inputStream.available()) > 0);
        return n6;
    }

    public Object setEnv(String string, Object object) {
        ValidateUtils.checkNotNull(string, "No key provided");
        if (object == null) {
            return this.env.remove(string);
        }
        return this.env.put(string, object);
    }

    protected void sendEnvVariables(Session session) {
        if (MapEntryUtils.size(this.env) > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending env variables ({}) Send SSH_MSG_CHANNEL_REQUEST env: {}", (Object)this, (Object)this.env);
            }
            for (Map.Entry entry : this.env.entrySet()) {
                String string = (String)entry.getKey();
                Object v2 = entry.getValue();
                String string2 = Objects.toString(v2);
                Buffer buffer = session.createBuffer((byte)98, string.length() + GenericUtils.length(string2) + 32);
                buffer.putInt(this.getRecipient());
                buffer.putString("env");
                buffer.putBoolean(false);
                buffer.putString(string);
                buffer.putString(string2);
                this.writePacket(buffer);
            }
        }
    }

    static /* synthetic */ IoWriteFuture access$000(ChannelSession channelSession) {
        return channelSession.sendEof();
    }
}

