/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import org.apache.sshd.client.channel.PtyCapableChannelSession;
import org.apache.sshd.common.channel.PtyChannelConfigurationHolder;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.core.CoreModuleProperties;

public class ChannelExec
extends PtyCapableChannelSession {
    private final String command;
    private final byte[] cmdBytes;

    public ChannelExec(String string, PtyChannelConfigurationHolder ptyChannelConfigurationHolder, Map map) {
        this(string, StandardCharsets.UTF_8, ptyChannelConfigurationHolder, map);
    }

    public ChannelExec(String string, Charset charset, PtyChannelConfigurationHolder ptyChannelConfigurationHolder, Map map) {
        super(false, ptyChannelConfigurationHolder, map);
        this.command = ValidateUtils.checkNotNullAndNotEmpty(string, "Command may not be null/empty");
        this.cmdBytes = this.command.getBytes(charset);
    }

    public ChannelExec(byte[] byArray, PtyChannelConfigurationHolder ptyChannelConfigurationHolder, Map map) {
        super(false, ptyChannelConfigurationHolder, map);
        this.cmdBytes = ValidateUtils.checkNotNullAndNotEmpty(byArray, "Command may not be null/empty");
        this.command = new String(byArray, StandardCharsets.UTF_8);
    }

    @Override
    protected void doOpen() {
        this.doOpenPty();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpen({}) send SSH_MSG_CHANNEL_REQUEST exec command={}", (Object)this, (Object)this.command);
        }
        Session session = this.getSession();
        boolean bl2 = (Boolean)CoreModuleProperties.REQUEST_EXEC_REPLY.getRequired(this);
        Buffer buffer = session.createBuffer((byte)98, this.cmdBytes.length + 32);
        buffer.putUInt(this.getRecipient());
        buffer.putString("exec");
        buffer.putBoolean(bl2);
        buffer.putBytes(this.cmdBytes);
        this.addPendingRequest("exec", bl2);
        this.writePacket(buffer);
        super.doOpen();
    }

    @Override
    public void handleSuccess() {
        Date date = this.removePendingRequest("exec");
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleSuccess({}) pending={}, command={}", new Object[]{this, date, this.command});
        }
    }

    @Override
    public void handleFailure() {
        Date date = this.removePendingRequest("exec");
        if (date != null) {
            this.log.warn("handleFailure({}) pending since={}, command={}", new Object[]{this, date, this.command});
            this.close(true);
        }
    }
}

