/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelAsyncInputStream;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.ChannelPipedInputStream;
import org.apache.sshd.common.channel.ChannelPipedOutputStream;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.StreamingChannel$Streaming;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class ChannelDirectTcpip
extends AbstractClientChannel {
    private final SshdSocketAddress local;
    private final SshdSocketAddress remote;
    private ChannelPipedOutputStream pipe;

    public ChannelDirectTcpip(SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2) {
        super("direct-tcpip");
        if (sshdSocketAddress == null) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                sshdSocketAddress = new SshdSocketAddress(inetAddress.getHostName(), 0);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalStateException("Unable to retrieve local host name");
            }
        }
        if (sshdSocketAddress2 == null) {
            throw new IllegalArgumentException("Remote address must not be null");
        }
        this.local = sshdSocketAddress;
        this.remote = sshdSocketAddress2;
    }

    @Override
    public synchronized OpenFuture open() {
        if (this.closeFuture.isClosed()) {
            throw new SshException("Session has been closed");
        }
        this.openFuture = new DefaultOpenFuture(this.remote, this.futureLock);
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({}) SSH_MSG_CHANNEL_OPEN", (Object)this);
        }
        Session session = this.getSession();
        String string = this.remote.getHostName();
        String string2 = this.local.getHostName();
        LocalWindow localWindow = this.getLocalWindow();
        String string3 = this.getChannelType();
        Buffer buffer = session.createBuffer((byte)90, string3.length() + string.length() + string2.length() + 64);
        buffer.putString(string3);
        buffer.putUInt(this.getChannelId());
        buffer.putUInt(localWindow.getSize());
        buffer.putUInt(localWindow.getPacketSize());
        buffer.putString(string);
        buffer.putUInt(this.remote.getPort());
        buffer.putString(string2);
        buffer.putUInt(this.local.getPort());
        this.writePacket(buffer);
        return this.openFuture;
    }

    @Override
    protected void doOpen() {
        if (this.streaming == StreamingChannel$Streaming.Async) {
            this.asyncIn = new ChannelAsyncOutputStream(this, 94);
            this.asyncOut = new ChannelAsyncInputStream(this);
        } else {
            this.invertedIn = this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
            ChannelPipedInputStream channelPipedInputStream = new ChannelPipedInputStream(this, this.getLocalWindow());
            this.pipe = new ChannelPipedOutputStream(channelPipedInputStream);
            this.invertedOut = this.in = channelPipedInputStream;
        }
    }

    @Override
    protected void doWriteData(byte[] byArray, int n2, long l2) {
        ValidateUtils.checkTrue(l2 <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", l2);
        this.pipe.write(byArray, n2, (int)l2);
        this.pipe.flush();
        LocalWindow localWindow = this.getLocalWindow();
        localWindow.release(l2);
    }

    public SshdSocketAddress getLocalSocketAddress() {
        return this.local;
    }

    public SshdSocketAddress getRemoteSocketAddress() {
        return this.remote;
    }
}

