/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.channel.AbstractClientChannel$1;
import org.apache.sshd.client.channel.AbstractClientChannel$NullIoInputStream;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.channel.exit.ExitSignalChannelRequestHandler;
import org.apache.sshd.client.channel.exit.ExitStatusChannelRequestHandler;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.ChannelAsyncInputStream;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.RemoteWindow;
import org.apache.sshd.common.channel.StreamingChannel$Streaming;
import org.apache.sshd.common.channel.exception.SshChannelOpenException;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.EventNotifier;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.IoUtils;

public abstract class AbstractClientChannel
extends AbstractChannel
implements ClientChannel {
    private static final InputStream NULL_INPUT_STREAM = new AbstractClientChannel$1();
    protected final AtomicBoolean opened = new AtomicBoolean();
    protected StreamingChannel$Streaming streaming;
    protected ChannelAsyncOutputStream asyncIn;
    protected ChannelAsyncInputStream asyncOut;
    protected ChannelAsyncInputStream asyncErr;
    protected InputStream in;
    protected OutputStream invertedIn;
    protected OutputStream out;
    protected InputStream invertedOut;
    protected OutputStream err;
    protected InputStream invertedErr;
    protected boolean redirectErrorStream;
    protected final AtomicReference exitStatusHolder = new AtomicReference<Object>(null);
    protected final AtomicReference exitSignalHolder = new AtomicReference<Object>(null);
    protected int openFailureReason;
    protected String openFailureMsg;
    protected String openFailureLang;
    protected OpenFuture openFuture;
    private final String channelType;

    protected AbstractClientChannel(String string) {
        this(string, Collections.emptyList());
    }

    protected AbstractClientChannel(String string2, Collection collection) {
        super(true, collection);
        this.channelType = ValidateUtils.checkNotNullAndNotEmpty(string2, "No channel type specified");
        this.streaming = StreamingChannel$Streaming.Sync;
        this.addChannelSignalRequestHandlers(string -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug("notifyEvent({}): {}", (Object)this, string);
            }
            this.notifyStateChanged((String)string);
        });
    }

    protected void addChannelSignalRequestHandlers(EventNotifier eventNotifier) {
        this.addRequestHandler(new ExitStatusChannelRequestHandler(this.exitStatusHolder, eventNotifier));
        this.addRequestHandler(new ExitSignalChannelRequestHandler(this.exitSignalHolder, eventNotifier));
    }

    @Override
    public String getChannelType() {
        return this.channelType;
    }

    @Override
    public StreamingChannel$Streaming getStreaming() {
        return this.streaming;
    }

    @Override
    public void setStreaming(StreamingChannel$Streaming streamingChannel$Streaming) {
        this.streaming = streamingChannel$Streaming;
    }

    @Override
    public IoOutputStream getAsyncIn() {
        return this.asyncIn;
    }

    @Override
    public IoInputStream getAsyncOut() {
        return this.asyncOut;
    }

    @Override
    public IoInputStream getAsyncErr() {
        if (this.asyncErr == this.asyncOut) {
            return AbstractClientChannel$NullIoInputStream.INSTANCE;
        }
        return this.asyncErr;
    }

    @Override
    public OutputStream getInvertedIn() {
        return this.invertedIn;
    }

    public InputStream getIn() {
        return this.in;
    }

    @Override
    public void setIn(InputStream inputStream) {
        this.in = inputStream;
    }

    @Override
    public InputStream getInvertedOut() {
        return this.invertedOut;
    }

    public OutputStream getOut() {
        return this.out;
    }

    @Override
    public void setOut(OutputStream outputStream) {
        this.out = outputStream;
    }

    @Override
    public InputStream getInvertedErr() {
        if (this.invertedErr == this.invertedOut) {
            return NULL_INPUT_STREAM;
        }
        return this.invertedErr;
    }

    public OutputStream getErr() {
        return this.err;
    }

    @Override
    public void setErr(OutputStream outputStream) {
        this.err = outputStream;
    }

    public boolean isRedirectErrorStream() {
        return this.redirectErrorStream;
    }

    @Override
    public void setRedirectErrorStream(boolean bl2) {
        this.redirectErrorStream = bl2;
    }

    @Override
    protected org.apache.sshd.common.Closeable getInnerCloseable() {
        return this.builder().when((SshFuture)this.openFuture).run(this.toString(), () -> {
            if (this.openFuture == null) {
                this.gracefulFuture.setClosed();
            }
            IoUtils.closeQuietly(this.in, this.out, this.err);
            IoUtils.closeQuietly((Closeable)this.invertedIn);
        }).parallel(this.asyncIn, this.asyncOut, this.asyncErr).close(super.getInnerCloseable()).build();
    }

    @Override
    public Set waitFor(Collection collection, long l2) {
        Objects.requireNonNull(collection, "No mask specified");
        boolean bl2 = this.log.isDebugEnabled();
        boolean bl3 = this.log.isTraceEnabled();
        long l3 = System.currentTimeMillis();
        Object object = this.futureLock;
        synchronized (object) {
            long l4 = l2;
            EnumSet<ClientChannelEvent> enumSet = EnumSet.noneOf(ClientChannelEvent.class);
            while (true) {
                block19: {
                    long l5;
                    long l6;
                    boolean bl4;
                    this.updateCurrentChannelState(enumSet);
                    if (bl2) {
                        if (enumSet.contains((Object)ClientChannelEvent.EXIT_STATUS)) {
                            this.log.debug("waitFor({}) mask={} - exit status={}", new Object[]{this, collection, this.exitStatusHolder});
                        }
                        if (enumSet.contains((Object)ClientChannelEvent.EXIT_SIGNAL)) {
                            this.log.debug("waitFor({}) mask={} - exit signal={}", new Object[]{this, collection, this.exitSignalHolder});
                        }
                    }
                    if (!(bl4 = Collections.disjoint(collection, enumSet))) {
                        if (bl3) {
                            this.log.trace("waitFor({}) call returning mask={}, cond={}", new Object[]{this, collection, enumSet});
                        }
                        return enumSet;
                    }
                    if (l2 > 0L && ((l6 = (l5 = System.currentTimeMillis()) - l3) >= l2 || l4 <= 0L)) {
                        if (bl3) {
                            this.log.trace("waitFor({}) call timeout {}/{} for mask={}: {}", new Object[]{this, l6, l2, collection, enumSet});
                        }
                        enumSet.add(ClientChannelEvent.TIMEOUT);
                        return enumSet;
                    }
                    if (bl3) {
                        this.log.trace("waitFor({}) waiting {} millis for lock - mask={}, cond={}", new Object[]{this, l4, collection, enumSet});
                    }
                    l5 = System.nanoTime();
                    try {
                        if (l2 > 0L) {
                            this.futureLock.wait(l4);
                        } else {
                            this.futureLock.wait();
                        }
                        l6 = System.nanoTime();
                        long l7 = l6 - l5;
                        if (bl3) {
                            this.log.trace("waitFor({}) lock notified on channel after {} nanos", (Object)this, (Object)l7);
                        }
                        if (l2 > 0L) {
                            long l8 = TimeUnit.MILLISECONDS.convert(l7, TimeUnit.NANOSECONDS);
                            if (l8 <= 0L) {
                                l8 = 123L;
                            }
                            l4 -= l8;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        long l9 = System.nanoTime();
                        long l10 = l9 - l5;
                        if (!bl3) break block19;
                        this.log.trace("waitFor({}) mask={} - ignoring interrupted exception after {} nanos", new Object[]{this, collection, l10});
                    }
                }
                enumSet.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getChannelState() {
        EnumSet<ClientChannelEvent> enumSet = EnumSet.noneOf(ClientChannelEvent.class);
        Object object = this.futureLock;
        synchronized (object) {
            return (Set)this.updateCurrentChannelState(enumSet);
        }
    }

    protected Collection updateCurrentChannelState(Collection collection) {
        if (this.openFuture != null && this.openFuture.isOpened()) {
            collection.add(ClientChannelEvent.OPENED);
        }
        if (this.closeFuture.isClosed() || this.closeSignaled.get() || this.unregisterSignaled.get() || this.isClosed()) {
            collection.add(ClientChannelEvent.CLOSED);
        }
        if (this.isEofSignalled()) {
            collection.add(ClientChannelEvent.EOF);
        }
        if (this.exitStatusHolder.get() != null) {
            collection.add(ClientChannelEvent.EXIT_STATUS);
        }
        if (this.exitSignalHolder.get() != null) {
            collection.add(ClientChannelEvent.EXIT_SIGNAL);
        }
        return collection;
    }

    @Override
    public synchronized OpenFuture open() {
        if (this.isClosing()) {
            throw new SshException("Session has been closed: " + this.state);
        }
        this.openFuture = new DefaultOpenFuture(this.toString(), this.futureLock);
        String string = this.getChannelType();
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({}) Send SSH_MSG_CHANNEL_OPEN - type={}", (Object)this, (Object)string);
        }
        Session session = this.getSession();
        LocalWindow localWindow = this.getLocalWindow();
        Buffer buffer = session.createBuffer((byte)90, string.length() + 32);
        buffer.putString(string);
        buffer.putUInt(this.getChannelId());
        buffer.putUInt(localWindow.getSize());
        buffer.putUInt(localWindow.getPacketSize());
        this.writePacket(buffer);
        return this.openFuture;
    }

    @Override
    public OpenFuture open(long l2, long l3, long l4, Buffer buffer) {
        throw new UnsupportedOperationException("open(" + l2 + "," + l3 + "," + l4 + ") N/A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleOpenSuccess(long l2, long l3, long l4, Buffer buffer) {
        this.setRecipient(l2);
        Session session = this.getSession();
        FactoryManager factoryManager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        RemoteWindow remoteWindow = this.getRemoteWindow();
        remoteWindow.init(l3, l4, factoryManager);
        String string = "SSH_MSG_CHANNEL_OPEN_CONFIRMATION";
        try {
            this.doOpen();
            this.signalChannelOpenSuccess();
            this.opened.set(true);
            OpenFuture openFuture = this.openFuture;
            openFuture.setOpened();
            if (openFuture.isCanceled()) {
                this.close(false).addListener(closeFuture -> openFuture.getCancellation().setCanceled());
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            string = throwable2.getClass().getName();
            this.signalChannelOpenFailure(throwable2);
            this.openFuture.setException(throwable2);
            this.closeFuture.setClosed();
            this.doCloseImmediately();
        }
        finally {
            this.notifyStateChanged(string);
        }
    }

    protected abstract void doOpen();

    @Override
    public void handleOpenFailure(Buffer buffer) {
        int n2 = buffer.getInt();
        String string = buffer.getString();
        String string2 = buffer.getString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleOpenFailure({}) reason={}, lang={}, msg={}", new Object[]{this, SshConstants.getOpenErrorCodeName(n2), string2, string});
        }
        this.openFailureReason = n2;
        this.openFailureMsg = string;
        this.openFailureLang = string2;
        this.openFuture.setException(new SshChannelOpenException(this.getChannelId(), n2, string));
        this.closeFuture.setClosed();
        this.doCloseImmediately();
        this.notifyStateChanged("SSH_MSG_CHANNEL_OPEN_FAILURE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWriteData(byte[] byArray, int n2, long l2) {
        if (this.isClosing()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doWriteData({}) ignored (len={}) channel state={}", new Object[]{this, l2, this.state});
            }
            return;
        }
        ValidateUtils.checkTrue(l2 <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", l2);
        if (this.asyncOut != null) {
            this.asyncOut.write(new ByteArrayBuffer(byArray, n2, (int)l2));
        } else if (this.out != null) {
            try {
                this.out.write(byArray, n2, (int)l2);
                this.out.flush();
            }
            finally {
                if (this.invertedOut == null) {
                    LocalWindow localWindow = this.getLocalWindow();
                    localWindow.release(l2);
                }
            }
        } else {
            throw new IllegalStateException("No output stream for channel");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWriteExtendedData(byte[] byArray, int n2, long l2) {
        if (this.isClosing()) {
            return;
        }
        ValidateUtils.checkTrue(l2 <= Integer.MAX_VALUE, "Extended data length exceeds int boundaries: %d", l2);
        if (this.asyncErr != null) {
            this.asyncErr.write(new ByteArrayBuffer(byArray, n2, (int)l2));
        } else if (this.err != null) {
            try {
                this.err.write(byArray, n2, (int)l2);
                this.err.flush();
            }
            finally {
                if (this.invertedErr == null) {
                    LocalWindow localWindow = this.getLocalWindow();
                    localWindow.release(l2);
                }
            }
        } else {
            throw new IllegalStateException("No error stream for channel");
        }
    }

    @Override
    public void handleWindowAdjust(Buffer buffer) {
        super.handleWindowAdjust(buffer);
        if (this.asyncIn != null) {
            this.asyncIn.onWindowExpanded();
        }
    }

    @Override
    protected boolean mayWrite() {
        if (this.asyncIn == null || !StreamingChannel$Streaming.Async.equals((Object)this.streaming)) {
            return super.mayWrite();
        }
        return !this.isClosed();
    }

    @Override
    public Integer getExitStatus() {
        return (Integer)this.exitStatusHolder.get();
    }

    @Override
    public String getExitSignal() {
        return (String)this.exitSignalHolder.get();
    }
}

