/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.pubkey;

import java.nio.channels.Channel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.client.auth.pubkey.AbstractKeyPairIterator;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyIterator$1;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyIterator$2;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.helper.LazyIterablesConcatenator;
import org.apache.sshd.common.util.helper.LazyMatchingTypeIterator;

public class UserAuthPublicKeyIterator
extends AbstractKeyPairIterator
implements Channel {
    private final AtomicBoolean open = new AtomicBoolean(true);
    private Iterator current;
    private SshAgent agent;

    public UserAuthPublicKeyIterator(ClientSession clientSession, SignatureFactoriesManager signatureFactoriesManager) {
        super(clientSession);
        try {
            Iterable iterable;
            ArrayList<Iterable> arrayList = new ArrayList<Iterable>(2);
            Iterable iterable2 = this.initializeAgentIdentities(clientSession);
            if (iterable2 != null) {
                arrayList.add(iterable2);
            }
            if ((iterable = this.initializeSessionIdentities(clientSession, signatureFactoriesManager)) != null) {
                arrayList.add(iterable);
            }
            if (arrayList.isEmpty()) {
                this.current = Collections.emptyIterator();
            } else {
                Iterable iterable3 = LazyIterablesConcatenator.lazyConcatenateIterables(arrayList);
                this.current = LazyMatchingTypeIterator.lazySelectMatchingTypes(iterable3.iterator(), PublicKeyIdentity.class);
            }
        }
        catch (Exception exception) {
            try {
                this.closeAgent();
            }
            catch (Exception exception2) {
                exception.addSuppressed(exception2);
            }
            throw exception;
        }
    }

    protected Iterable initializeSessionIdentities(ClientSession clientSession, SignatureFactoriesManager signatureFactoriesManager) {
        return new UserAuthPublicKeyIterator$1(this, clientSession, signatureFactoriesManager);
    }

    protected Iterable initializeAgentIdentities(ClientSession clientSession) {
        FactoryManager factoryManager = Objects.requireNonNull(clientSession.getFactoryManager(), "No session factory manager");
        SshAgentFactory sshAgentFactory = factoryManager.getAgentFactory();
        if (sshAgentFactory == null) {
            return null;
        }
        this.agent = sshAgentFactory.createClient(clientSession, factoryManager);
        if (this.agent == null) {
            return null;
        }
        return new UserAuthPublicKeyIterator$2(this);
    }

    @Override
    public boolean hasNext() {
        if (!this.isOpen()) {
            return false;
        }
        return this.current.hasNext();
    }

    public PublicKeyIdentity next() {
        if (!this.isOpen()) {
            throw new NoSuchElementException("Iterator is closed");
        }
        return (PublicKeyIdentity)this.current.next();
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() {
        if (this.open.getAndSet(false)) {
            this.closeAgent();
        }
    }

    protected void closeAgent() {
        if (this.agent != null) {
            try {
                this.agent.close();
            }
            finally {
                this.agent = null;
            }
        }
    }

    static /* synthetic */ SshAgent access$200(UserAuthPublicKeyIterator userAuthPublicKeyIterator) {
        return userAuthPublicKeyIterator.agent;
    }
}

