/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.pubkey;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.auth.pubkey.KeyPairIdentity;
import org.apache.sshd.client.auth.pubkey.PublicKeyAuthenticationReporter;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyIterator;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.AttributeRepository$AttributeKey;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.OpenSshCertificate$Type;
import org.apache.sshd.common.kex.extension.DefaultClientKexExtensionHandler;
import org.apache.sshd.common.signature.SignatureFactoriesHolder;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class UserAuthPublicKey
extends AbstractUserAuth
implements SignatureFactoriesManager {
    public static final String NAME = "publickey";
    public static final AttributeRepository$AttributeKey USE_DEFAULT_IDENTITIES = new AttributeRepository$AttributeKey();
    public static final AttributeRepository$AttributeKey IDENTITY_AGENT = new AttributeRepository$AttributeKey();
    protected final Deque currentAlgorithms = new LinkedList();
    protected Iterator keys;
    protected PublicKeyIdentity current;
    protected List factories;
    protected String chosenAlgorithm;

    public UserAuthPublicKey() {
        this((List)null);
    }

    public UserAuthPublicKey(List list) {
        super(NAME);
        this.factories = list;
        this.setCancellable(true);
    }

    @Override
    public List getSignatureFactories() {
        return this.factories;
    }

    @Override
    public void setSignatureFactories(List list) {
        this.factories = list;
    }

    @Override
    public void init(ClientSession clientSession, String string) {
        super.init(clientSession, string);
        this.releaseKeys();
        try {
            this.keys = this.createPublicKeyIterator(clientSession, this);
        }
        catch (Error error) {
            this.warn("init({})[{}] failed ({}) to initialize session keys: {}", clientSession, string, error.getClass().getSimpleName(), error.getMessage(), error);
            throw new RuntimeSshException(error);
        }
    }

    protected Iterator createPublicKeyIterator(ClientSession clientSession, SignatureFactoriesManager signatureFactoriesManager) {
        return new UserAuthPublicKeyIterator(clientSession, signatureFactoriesManager);
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession clientSession, String string) {
        boolean bl2;
        Serializable serializable;
        String string2;
        PublicKey publicKey;
        KeyPair keyPair;
        Object object;
        boolean bl3 = this.log.isDebugEnabled();
        String string3 = null;
        if (this.current == null) {
            this.currentAlgorithms.clear();
            this.chosenAlgorithm = null;
        } else if (!this.currentAlgorithms.isEmpty()) {
            string3 = (String)this.currentAlgorithms.poll();
            if (this.chosenAlgorithm != null && (object = (Set)clientSession.getAttribute(DefaultClientKexExtensionHandler.SERVER_ALGORITHMS)) != null && object.contains(this.chosenAlgorithm)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("sendAuthDataRequest({})[{}] server rejected publickey authentication with known signature algorithm {}", new Object[]{clientSession, string, this.chosenAlgorithm});
                }
                string3 = null;
            }
        }
        object = clientSession.getPublicKeyAuthenticationReporter();
        do {
            if (string3 == null) {
                try {
                    this.current = this.resolveAttemptedPublicKeyIdentity(clientSession, string, (PublicKeyAuthenticationReporter)object);
                }
                catch (Error error) {
                    this.warn("sendAuthDataRequest({})[{}] failed ({}) to get next key: {}", clientSession, string, error.getClass().getSimpleName(), error.getMessage(), error);
                    throw new RuntimeSshException(error);
                }
                this.currentAlgorithms.clear();
                this.chosenAlgorithm = null;
                if (this.current == null) {
                    if (bl3) {
                        this.log.debug("resolveAttemptedPublicKeyIdentity({})[{}] no more keys to send", (Object)clientSession, (Object)string);
                    }
                    if (object != null) {
                        object.signalAuthenticationExhausted(clientSession, string);
                    }
                    return false;
                }
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("sendAuthDataRequest({})[{}] current key details: {}", new Object[]{clientSession, string, this.current});
            }
            try {
                keyPair = this.current.getKeyIdentity();
            }
            catch (Error error) {
                this.warn("sendAuthDataRequest({})[{}] failed ({}) to retrieve key identity: {}", clientSession, string, error.getClass().getSimpleName(), error.getMessage(), error);
                throw new RuntimeSshException(error);
            }
            publicKey = keyPair.getPublic();
            if (string3 != null) continue;
            string2 = KeyUtils.getKeyType(publicKey);
            serializable = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            serializable.addAll(KeyUtils.getAllEquivalentKeyTypes(string2));
            serializable.add(string2);
            List list = null;
            if (this.current instanceof SignatureFactoriesHolder) {
                list = ((SignatureFactoriesHolder)((Object)this.current)).getSignatureFactories();
            }
            if (GenericUtils.isEmpty(list)) {
                list = this.getSignatureFactories();
            }
            if (GenericUtils.isEmpty(list)) {
                list = clientSession.getSignatureFactories();
            }
            if (list != null) {
                list.forEach(arg_0 -> this.lambda$sendAuthDataRequest$0((Set)((Object)serializable), arg_0));
            }
            if (!GenericUtils.isEmpty(string3 = (String)this.currentAlgorithms.poll()) || !GenericUtils.isEmpty(string3 = this.getDefaultSignatureAlgorithm(clientSession, string, this.current, keyPair, string2))) continue;
            string3 = null;
            if (bl3) {
                this.log.debug("sendAuthDataRequest({})[{}] skipping {} key {}; no signature algorithm", new Object[]{clientSession, string, string2, KeyUtils.getFingerPrint(publicKey)});
            }
            if (object == null) continue;
            object.signalIdentitySkipped(clientSession, string, keyPair);
        } while (string3 == null);
        string2 = this.getName();
        serializable = (Integer)clientSession.getAttribute(DefaultClientKexExtensionHandler.HOSTBOUND_AUTHENTICATION);
        boolean bl4 = bl2 = serializable != null && (Integer)serializable == 0;
        if (bl2) {
            string2 = "publickey-hostbound-v00@openssh.com";
        }
        if (bl3) {
            this.log.debug("sendAuthDataRequest({})[{}] send SSH_MSG_USERAUTH_REQUEST request {} type={} - fingerprint={}", new Object[]{clientSession, string, string2, string3, KeyUtils.getFingerPrint(publicKey)});
        }
        if (object != null) {
            object.signalAuthenticationAttempt(clientSession, string, keyPair, string3);
        }
        this.chosenAlgorithm = string3;
        Buffer buffer = clientSession.createBuffer((byte)50);
        buffer.putString(clientSession.getUsername());
        buffer.putString(string);
        buffer.putString(string2);
        buffer.putBoolean(false);
        buffer.putString(string3);
        buffer.putPublicKey(publicKey);
        if (bl2) {
            buffer.putPublicKey(clientSession.getServerKey());
        }
        this.setCancellable(true);
        clientSession.writePacket(buffer);
        return true;
    }

    protected PublicKeyIdentity resolveAttemptedPublicKeyIdentity(ClientSession clientSession, String string) {
        return this.resolveAttemptedPublicKeyIdentity(clientSession, string, null);
    }

    protected PublicKeyIdentity resolveAttemptedPublicKeyIdentity(ClientSession clientSession, String string, PublicKeyAuthenticationReporter publicKeyAuthenticationReporter) {
        KeyPair keyPair;
        Object object;
        if (this.keys != null) {
            while (this.keys.hasNext()) {
                object = (PublicKeyIdentity)this.keys.next();
                keyPair = object.getKeyIdentity();
                PublicKey publicKey = keyPair.getPublic();
                if (publicKey instanceof OpenSshCertificate) {
                    OpenSshCertificate openSshCertificate = (OpenSshCertificate)publicKey;
                    if (!OpenSshCertificate$Type.USER.equals((Object)openSshCertificate.getType())) {
                        this.log.warn("resolveAttemptedPublicKeyIdentity({})[{}]: public key certificate {} {} (id={}) is not a user certificate", new Object[]{clientSession, string, KeyUtils.getKeyType(openSshCertificate), KeyUtils.getFingerPrint(openSshCertificate), openSshCertificate.getId()});
                        if (publicKeyAuthenticationReporter == null) continue;
                        publicKeyAuthenticationReporter.signalIdentitySkipped(clientSession, string, keyPair);
                        continue;
                    }
                    if (!OpenSshCertificate.isValidNow(openSshCertificate)) {
                        this.log.warn("resolveAttemptedPublicKeyIdentity({})[{}]: public key certificate {} {} (id={}) is not valid now", new Object[]{clientSession, string, KeyUtils.getKeyType(openSshCertificate), KeyUtils.getFingerPrint(openSshCertificate), openSshCertificate.getId()});
                        if (publicKeyAuthenticationReporter == null) continue;
                        publicKeyAuthenticationReporter.signalIdentitySkipped(clientSession, string, keyPair);
                        continue;
                    }
                }
                return object;
            }
        }
        if ((object = clientSession.getUserInteraction()) == null || !object.isInteractionAllowed(clientSession)) {
            return null;
        }
        keyPair = object.resolveAuthPublicKeyIdentityAttempt(clientSession);
        if (keyPair == null) {
            return null;
        }
        return new KeyPairIdentity(this, clientSession, keyPair);
    }

    protected String getDefaultSignatureAlgorithm(ClientSession clientSession, String string, PublicKeyIdentity publicKeyIdentity, KeyPair keyPair, String string2) {
        return null;
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession clientSession, String string, Buffer buffer) {
        KeyPair keyPair;
        int n2;
        boolean bl2;
        String string2 = this.getName();
        PublicKey publicKey = null;
        Integer n3 = (Integer)clientSession.getAttribute(DefaultClientKexExtensionHandler.HOSTBOUND_AUTHENTICATION);
        boolean bl3 = bl2 = n3 != null && n3 == 0;
        if (bl2) {
            string2 = "publickey-hostbound-v00@openssh.com";
            publicKey = clientSession.getServerKey();
        }
        if ((n2 = buffer.getUByte()) != 60) {
            throw new IllegalStateException("processAuthDataRequest(" + clientSession + ")[" + string + "][" + string2 + "] received unknown packet: cmd=" + SshConstants.getCommandMessageName(n2));
        }
        boolean bl4 = this.log.isDebugEnabled();
        try {
            keyPair = this.current.getKeyIdentity();
        }
        catch (Error error) {
            this.warn("processAuthDataRequest({})[{}][{}] failed ({}) to retrieve key identity: {}", clientSession, string, string2, error.getClass().getSimpleName(), error.getMessage(), error);
            throw new RuntimeSshException(error);
        }
        PublicKey publicKey2 = keyPair.getPublic();
        String string3 = buffer.getString();
        PublicKey publicKey3 = buffer.getPublicKey();
        if (bl4) {
            this.log.debug("processAuthDataRequest({})[{}][{}] SSH_MSG_USERAUTH_PK_OK type={}, fingerprint={}", new Object[]{clientSession, string, string2, string3, KeyUtils.getFingerPrint(publicKey3)});
        }
        if (!KeyUtils.compareKeys(publicKey3, publicKey2)) {
            throw new InvalidKeySpecException("processAuthDataRequest(" + clientSession + ")[" + string + "][" + string2 + "] mismatched " + string3 + " keys: expected=" + KeyUtils.getFingerPrint(publicKey2) + ", actual=" + KeyUtils.getFingerPrint(publicKey3));
        }
        if (!this.chosenAlgorithm.equalsIgnoreCase(string3)) {
            this.log.warn("processAuthDataRequest({})[{}][{}] sent algorithm {} but got back {} from {}", new Object[]{clientSession, string, string2, this.chosenAlgorithm, string3, clientSession.getServerVersion()});
        }
        String string4 = clientSession.getUsername();
        String string5 = this.chosenAlgorithm;
        int n4 = GenericUtils.length(string4) + GenericUtils.length(string) + GenericUtils.length(string2) + GenericUtils.length(string5) + 256 + 64;
        buffer = clientSession.createBuffer((byte)50, n4);
        buffer.putString(string4);
        buffer.putString(string);
        buffer.putString(string2);
        buffer.putBoolean(true);
        buffer.putString(string5);
        buffer.putPublicKey(publicKey2);
        if (publicKey != null) {
            buffer.putPublicKey(publicKey);
        }
        if (bl4) {
            this.log.debug("processAuthDataRequest({})[{}][{}]: signing with algorithm {}", new Object[]{clientSession, string, string2, string5});
        }
        byte[] byArray = this.appendSignature(clientSession, string, string2, string4, string5, publicKey2, publicKey, buffer);
        PublicKeyAuthenticationReporter publicKeyAuthenticationReporter = clientSession.getPublicKeyAuthenticationReporter();
        if (publicKeyAuthenticationReporter != null) {
            publicKeyAuthenticationReporter.signalSignatureAttempt(clientSession, string, keyPair, string5, byArray);
        }
        this.setCancellable(false);
        clientSession.writePacket(buffer);
        return true;
    }

    protected byte[] appendSignature(ClientSession clientSession, String string, String string2, String string3, String string4, PublicKey publicKey, PublicKey publicKey2, Buffer buffer) {
        byte[] byArray;
        Object object;
        byte[] byArray2 = clientSession.getSessionId();
        int n2 = byArray2.length + string3.length() + string.length() + string2.length() + string4.length() + 256 + 64;
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(n2, false);
        byteArrayBuffer.putBytes(byArray2);
        ((Buffer)byteArrayBuffer).putByte((byte)50);
        byteArrayBuffer.putString(string3);
        byteArrayBuffer.putString(string);
        byteArrayBuffer.putString(string2);
        byteArrayBuffer.putBoolean(true);
        byteArrayBuffer.putString(string4);
        byteArrayBuffer.putPublicKey(publicKey);
        if (publicKey2 != null) {
            byteArrayBuffer.putPublicKey(publicKey2);
        }
        byte[] byArray3 = byteArrayBuffer.getCompactData();
        try {
            object = this.current.sign(clientSession, string4, byArray3);
            String string5 = (String)object.getKey();
            ValidateUtils.checkState(string4.equalsIgnoreCase(string5), "Mismatched signature type generated: requested=%s, used=%s", string4, string5);
            byArray = (byte[])object.getValue();
        }
        catch (Error error) {
            this.warn("appendSignature({})[{}][{}] failed ({}) to sign contents using {}: {}", clientSession, string, string2, error.getClass().getSimpleName(), string4, error.getMessage(), error);
            throw new RuntimeSshException(error);
        }
        object = KeyUtils.getSignatureAlgorithm(string4, publicKey);
        if (this.log.isTraceEnabled()) {
            this.log.trace("appendSignature({})[{}] name={}, key type={}, fingerprint={} - verification data={}", new Object[]{clientSession, string, string2, object, KeyUtils.getFingerPrint(publicKey), BufferUtils.toHex(byArray3)});
            this.log.trace("appendSignature({})[{}] name={}, key type={}, fingerprint={} - generated signature={}", new Object[]{clientSession, string, string2, object, KeyUtils.getFingerPrint(publicKey), BufferUtils.toHex(byArray)});
        }
        byteArrayBuffer.clear();
        byteArrayBuffer.putString((String)object);
        byteArrayBuffer.putBytes(byArray);
        buffer.putBytes(((Buffer)byteArrayBuffer).array(), ((Buffer)byteArrayBuffer).rpos(), byteArrayBuffer.available());
        return byArray;
    }

    @Override
    public void signalAuthMethodSuccess(ClientSession clientSession, String string, Buffer buffer) {
        PublicKeyAuthenticationReporter publicKeyAuthenticationReporter = clientSession.getPublicKeyAuthenticationReporter();
        if (publicKeyAuthenticationReporter != null) {
            publicKeyAuthenticationReporter.signalAuthenticationSuccess(clientSession, string, this.current == null ? null : this.current.getKeyIdentity());
        }
    }

    @Override
    public void signalAuthMethodFailure(ClientSession clientSession, String string, boolean bl2, List list, Buffer buffer) {
        PublicKeyAuthenticationReporter publicKeyAuthenticationReporter = clientSession.getPublicKeyAuthenticationReporter();
        if (publicKeyAuthenticationReporter != null) {
            KeyPair keyPair = this.current == null ? null : this.current.getKeyIdentity();
            publicKeyAuthenticationReporter.signalAuthenticationFailure(clientSession, string, keyPair, bl2, list);
        }
    }

    @Override
    public void destroy() {
        try {
            this.releaseKeys();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Failed (" + iOException.getClass().getSimpleName() + ") to close agent: " + iOException.getMessage(), iOException);
        }
        super.destroy();
    }

    protected void releaseKeys() {
        this.currentAlgorithms.clear();
        this.current = null;
        this.chosenAlgorithm = null;
        try {
            if (this.keys instanceof Closeable) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("releaseKeys({}) closing {}", (Object)this.getClientSession(), (Object)this.keys);
                }
                ((Closeable)((Object)this.keys)).close();
            }
        }
        finally {
            this.keys = null;
        }
    }

    private /* synthetic */ void lambda$sendAuthDataRequest$0(Set set, NamedFactory namedFactory) {
        if (set.contains(namedFactory.getName())) {
            this.currentAlgorithms.add(namedFactory.getName());
        }
    }
}

