/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.pubkey;

import java.security.PublicKey;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.client.auth.pubkey.AbstractKeyPairIterator;
import org.apache.sshd.client.auth.pubkey.KeyAgentIdentity;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.GenericUtils;

public class SshAgentPublicKeyIterator
extends AbstractKeyPairIterator {
    private final SshAgent agent;
    private final Iterator keys;

    public SshAgentPublicKeyIterator(ClientSession clientSession, SshAgent sshAgent) {
        super(clientSession);
        this.agent = Objects.requireNonNull(sshAgent, "No agent");
        this.keys = GenericUtils.iteratorOf(sshAgent.getIdentities());
    }

    @Override
    public boolean hasNext() {
        return this.keys != null && this.keys.hasNext();
    }

    public KeyAgentIdentity next() {
        Map.Entry entry = (Map.Entry)this.keys.next();
        return new KeyAgentIdentity(this.agent, (PublicKey)entry.getKey(), (String)entry.getValue());
    }
}

